/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.uima.pear.tools.InstallationController;

public class SimplePackageSelector
implements InstallationController.PackageSelector {
    private PrintWriter _stdOut = null;
    private PrintWriter _stdErr = null;
    private BufferedReader _stdIn = new BufferedReader(new InputStreamReader(System.in));

    public SimplePackageSelector(PrintWriter stdOut, PrintWriter stdErr) {
        this();
        this._stdOut = stdOut;
        this._stdErr = stdErr;
    }

    public SimplePackageSelector() {
    }

    public File selectPackageDirectory(String componentId) {
        if (this._stdOut != null) {
            this._stdOut.println("> If the " + componentId + " component is already installed in your file system,");
            this._stdOut.print("> enter the " + componentId + " root directory: ");
            this._stdOut.flush();
        } else {
            System.out.println("> If the " + componentId + " component is already installed in your file system,");
            System.out.print("> enter the " + componentId + " root directory: ");
            System.out.flush();
        }
        File selectedDir = null;
        try {
            String dirPath = this._stdIn.readLine();
            if (dirPath != null && dirPath.length() > 0) {
                File dir = new File(dirPath);
                if (dir.isDirectory()) {
                    selectedDir = dir;
                } else if (this._stdErr != null) {
                    this._stdErr.println("> invalid directory");
                } else {
                    System.err.println("> invalid directory");
                }
            }
        }
        catch (Exception e) {
            if (this._stdErr != null) {
                e.printStackTrace(this._stdErr);
            }
            e.printStackTrace(System.err);
        }
        return selectedDir;
    }

    public File selectPackageFile(String componentId) {
        if (this._stdOut != null) {
            this._stdOut.print("> Enter the " + componentId + " PEAR file path: ");
            this._stdOut.flush();
        } else {
            System.out.print("> Enter the " + componentId + " PEAR file path: ");
            System.out.flush();
        }
        File selectedFile = null;
        try {
            String filePath = this._stdIn.readLine();
            if (filePath != null && filePath.length() > 0) {
                File file = new File(filePath);
                if (file.isFile()) {
                    selectedFile = file;
                } else {
                    if (this._stdErr != null) {
                        this._stdErr.println("> file not found");
                    } else {
                        System.err.println("> file not found");
                    }
                    selectedFile = null;
                }
            }
        }
        catch (Exception e) {
            if (this._stdErr != null) {
                e.printStackTrace(this._stdErr);
            }
            e.printStackTrace(System.err);
        }
        return selectedFile;
    }

    public URL selectPackageUrl(String componentId) {
        if (this._stdOut != null) {
            this._stdOut.print("> Enter the " + componentId + " PEAR package URL: ");
            this._stdOut.flush();
        } else {
            System.out.print("> Enter the " + componentId + " PEAR package URL: ");
            System.out.flush();
        }
        URL selectedUrl = null;
        try {
            String urlString = this._stdIn.readLine();
            if (urlString != null && urlString.length() > 0) {
                try {
                    selectedUrl = new URL(urlString);
                }
                catch (MalformedURLException e) {
                    if (this._stdErr != null) {
                        this._stdErr.println("> invalid URL - " + e.toString());
                    } else {
                        System.err.println("> invalid URL - " + e.toString());
                    }
                    selectedUrl = null;
                }
            }
        }
        catch (Exception e) {
            if (this._stdErr != null) {
                e.printStackTrace(this._stdErr);
            }
            e.printStackTrace(System.err);
        }
        return selectedUrl;
    }
}

