/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.bhv.outsidesql;

import java.util.List;
import org.seasar.robot.dbflute.DBDef;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommand;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.robot.dbflute.bhv.core.command.AbstractOutsideSqlCommand;
import org.seasar.robot.dbflute.bhv.core.command.OutsideSqlCallCommand;
import org.seasar.robot.dbflute.bhv.core.command.OutsideSqlExecuteCommand;
import org.seasar.robot.dbflute.bhv.core.command.OutsideSqlSelectListCommand;
import org.seasar.robot.dbflute.bhv.outsidesql.OutsideSqlCursorExecutor;
import org.seasar.robot.dbflute.bhv.outsidesql.OutsideSqlEntityExecutor;
import org.seasar.robot.dbflute.bhv.outsidesql.OutsideSqlPagingExecutor;
import org.seasar.robot.dbflute.bhv.outsidesql.factory.OutsideSqlContextFactory;
import org.seasar.robot.dbflute.bhv.outsidesql.factory.OutsideSqlExecutorFactory;
import org.seasar.robot.dbflute.cbean.ListResultBean;
import org.seasar.robot.dbflute.cbean.ResultBeanBuilder;
import org.seasar.robot.dbflute.exception.FetchingOverSafetySizeException;
import org.seasar.robot.dbflute.exception.thrower.BehaviorExceptionThrower;
import org.seasar.robot.dbflute.jdbc.FetchBean;
import org.seasar.robot.dbflute.jdbc.StatementConfig;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlFilter;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.robot.dbflute.outsidesql.ProcedurePmb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutsideSqlBasicExecutor {
    protected final BehaviorCommandInvoker _behaviorCommandInvoker;
    protected final String _tableDbName;
    protected final DBDef _currentDBDef;
    protected final StatementConfig _defaultStatementConfig;
    protected final OutsideSqlOption _outsideSqlOption;
    protected final OutsideSqlContextFactory _outsideSqlContextFactory;
    protected final OutsideSqlFilter _outsideSqlFilter;
    protected final OutsideSqlExecutorFactory _outsideSqlExecutorFactory;
    protected boolean _removeBlockComment;
    protected boolean _removeLineComment;
    protected boolean _formatSql;
    protected StatementConfig _statementConfig;

    public OutsideSqlBasicExecutor(BehaviorCommandInvoker behaviorCommandInvoker, String tableDbName, DBDef currentDBDef, StatementConfig defaultStatementConfig, OutsideSqlOption outsideSqlOption, OutsideSqlContextFactory outsideSqlContextFactory, OutsideSqlFilter outsideSqlFilter, OutsideSqlExecutorFactory outsideSqlExecutorFactory) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
        this._tableDbName = tableDbName;
        this._currentDBDef = currentDBDef;
        this._defaultStatementConfig = defaultStatementConfig;
        if (outsideSqlOption != null) {
            this._outsideSqlOption = outsideSqlOption;
        } else {
            this._outsideSqlOption = new OutsideSqlOption();
            this._outsideSqlOption.setTableDbName(tableDbName);
        }
        this._outsideSqlContextFactory = outsideSqlContextFactory;
        this._outsideSqlFilter = outsideSqlFilter;
        this._outsideSqlExecutorFactory = outsideSqlExecutorFactory;
    }

    public <ENTITY> ListResultBean<ENTITY> selectList(String path, Object pmb, Class<ENTITY> entityType) {
        return this.doSelectList(path, pmb, entityType);
    }

    protected <ENTITY> ListResultBean<ENTITY> doSelectList(String path, Object pmb, Class<ENTITY> entityType) {
        try {
            List<ENTITY> resultList = this.invoke(this.createSelectListCommand(path, pmb, entityType));
            return this.createListResultBean(resultList);
        }
        catch (FetchingOverSafetySizeException e) {
            this.throwDangerousResultSizeException(pmb, e);
            return null;
        }
    }

    protected <ENTITY> ListResultBean<ENTITY> createListResultBean(List<ENTITY> selectedList) {
        return new ResultBeanBuilder<ENTITY>(this._tableDbName).buildListResultBean(selectedList);
    }

    protected void throwDangerousResultSizeException(Object pmb, FetchingOverSafetySizeException e) {
        if (!(pmb instanceof FetchBean)) {
            String msg = "The exception should be thrown only when the parameter-bean is instance of fetch-bean:";
            msg = msg + " pmb=" + (pmb != null ? pmb.getClass().getName() : null);
            throw new IllegalStateException(msg, e);
        }
        this.createBhvExThrower().throwDangerousResultSizeException((FetchBean)pmb, e);
    }

    public int execute(String path, Object pmb) {
        return this.invoke(this.createExecuteCommand(path, pmb));
    }

    public void call(ProcedurePmb pmb) {
        if (pmb == null) {
            throw new IllegalArgumentException("The argument of call() 'pmb' should not be null!");
        }
        try {
            this.invoke(this.createCallCommand(pmb.getProcedureName(), pmb));
        }
        catch (FetchingOverSafetySizeException e) {
            this.throwDangerousResultSizeException(pmb, e);
        }
    }

    protected <ENTITY> BehaviorCommand<List<ENTITY>> createSelectListCommand(String path, Object pmb, Class<ENTITY> entityType) {
        OutsideSqlSelectListCommand<ENTITY> newed = this.newOutsideSqlSelectListCommand();
        OutsideSqlSelectListCommand<ENTITY> cmd = this.xsetupCommand(newed, path, pmb);
        cmd.setEntityType(entityType);
        return cmd;
    }

    protected <ENTITY> OutsideSqlSelectListCommand<ENTITY> newOutsideSqlSelectListCommand() {
        return new OutsideSqlSelectListCommand();
    }

    protected BehaviorCommand<Integer> createExecuteCommand(String path, Object pmb) {
        return this.xsetupCommand(this.newOutsideSqlExecuteCommand(), path, pmb);
    }

    protected OutsideSqlExecuteCommand newOutsideSqlExecuteCommand() {
        return new OutsideSqlExecuteCommand();
    }

    protected BehaviorCommand<Void> createCallCommand(String path, Object pmb) {
        return this.xsetupCommand(this.newOutsideSqlCallCommand(), path, pmb);
    }

    protected OutsideSqlCallCommand newOutsideSqlCallCommand() {
        return new OutsideSqlCallCommand();
    }

    protected <COMMAND extends AbstractOutsideSqlCommand<?>> COMMAND xsetupCommand(COMMAND cmd, String path, Object pmb) {
        cmd.setTableDbName(this._tableDbName);
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setOutsideSqlPath(path);
        cmd.setParameterBean(pmb);
        cmd.setOutsideSqlOption(this._outsideSqlOption);
        cmd.setCurrentDBDef(this._currentDBDef);
        cmd.setOutsideSqlContextFactory(this._outsideSqlContextFactory);
        cmd.setOutsideSqlFilter(this._outsideSqlFilter);
        return cmd;
    }

    protected <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        return this._behaviorCommandInvoker.invoke(behaviorCommand);
    }

    public OutsideSqlPagingExecutor manualPaging() {
        this._outsideSqlOption.manualPaging();
        return this.createOutsideSqlPagingExecutor();
    }

    public OutsideSqlPagingExecutor autoPaging() {
        this._outsideSqlOption.autoPaging();
        return this.createOutsideSqlPagingExecutor();
    }

    protected OutsideSqlPagingExecutor createOutsideSqlPagingExecutor() {
        return this._outsideSqlExecutorFactory.createPaging(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._defaultStatementConfig, this._outsideSqlOption);
    }

    public OutsideSqlCursorExecutor<Object> cursorHandling() {
        return this.createOutsideSqlCursorExecutor();
    }

    protected OutsideSqlCursorExecutor<Object> createOutsideSqlCursorExecutor() {
        return this._outsideSqlExecutorFactory.createCursor(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._outsideSqlOption);
    }

    public OutsideSqlEntityExecutor<Object> entityHandling() {
        return this.createOutsideSqlEntityExecutor();
    }

    protected OutsideSqlEntityExecutor<Object> createOutsideSqlEntityExecutor() {
        return this._outsideSqlExecutorFactory.createEntity(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._defaultStatementConfig, this._outsideSqlOption);
    }

    public OutsideSqlBasicExecutor removeBlockComment() {
        this._outsideSqlOption.removeBlockComment();
        return this;
    }

    public OutsideSqlBasicExecutor removeLineComment() {
        this._outsideSqlOption.removeLineComment();
        return this;
    }

    public OutsideSqlBasicExecutor formatSql() {
        this._outsideSqlOption.formatSql();
        return this;
    }

    public OutsideSqlBasicExecutor configure(StatementConfig statementConfig) {
        this._outsideSqlOption.setStatementConfig(statementConfig);
        return this;
    }

    protected BehaviorExceptionThrower createBhvExThrower() {
        return this._behaviorCommandInvoker.createBehaviorExceptionThrower();
    }
}

