/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.extension;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.robot.dbflute.Entity;
import org.seasar.robot.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.robot.dbflute.resource.ResourceContext;
import org.seasar.robot.dbflute.s2dao.identity.TnIdentifierGenerator;
import org.seasar.robot.dbflute.s2dao.identity.TnIdentifierGeneratorFactory;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.robot.dbflute.s2dao.metadata.impl.TnBeanMetaDataFactoryImpl;
import org.seasar.robot.dbflute.s2dao.metadata.impl.TnBeanMetaDataImpl;
import org.seasar.robot.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnBeanMetaDataFactoryExtension
extends TnBeanMetaDataFactoryImpl {
    private static final Log _log = LogFactory.getLog(TnBeanMetaDataFactoryExtension.class);
    protected final Map<Class<?>, TnBeanMetaData> _metaMap = this.newConcurrentHashMap();

    @Override
    public TnBeanMetaData createBeanMetaData(Class<?> beanClass) {
        TnBeanMetaData cachedMeta = this.findCachedMeta(beanClass);
        if (cachedMeta != null) {
            return cachedMeta;
        }
        return super.createBeanMetaData(beanClass);
    }

    @Override
    public TnBeanMetaData createBeanMetaData(Class<?> beanClass, int relationNestLevel) {
        TnBeanMetaData cachedMeta = this.findCachedMeta(beanClass);
        if (cachedMeta != null) {
            return cachedMeta;
        }
        return super.createBeanMetaData(beanClass, relationNestLevel);
    }

    @Override
    public TnBeanMetaData createBeanMetaData(DatabaseMetaData dbMetaData, Class<?> beanClass, int relationNestLevel) {
        TnBeanMetaData cachedMeta = this.findOrCreateCachedMetaIfNeeds(dbMetaData, beanClass, relationNestLevel);
        if (cachedMeta != null) {
            return cachedMeta;
        }
        return super.createBeanMetaData(dbMetaData, beanClass, relationNestLevel);
    }

    protected TnBeanMetaData findCachedMeta(Class<?> beanClass) {
        TnBeanMetaData cachedMeta;
        if (this.isDBFluteEntity(beanClass) && (cachedMeta = this.getMetaFromCache(beanClass)) != null) {
            return cachedMeta;
        }
        return null;
    }

    protected TnBeanMetaData findOrCreateCachedMetaIfNeeds(DatabaseMetaData dbMetaData, Class<?> beanClass, int relationNestLevel) {
        if (this.isDBFluteEntity(beanClass)) {
            TnBeanMetaData cachedMeta = this.getMetaFromCache(beanClass);
            if (cachedMeta != null) {
                return cachedMeta;
            }
            return super.createBeanMetaData(dbMetaData, beanClass, 0);
        }
        return null;
    }

    @Override
    protected TnBeanMetaDataImpl createBeanMetaDataImpl(Class<?> beanClass) {
        return new TnBeanMetaDataImpl(beanClass){
            protected final List<TnIdentifierGenerator> _internalIdentifierGeneratorList;
            protected final Map<String, TnIdentifierGenerator> _internalIdentifierGeneratorsByPropertyName;
            {
                this._internalIdentifierGeneratorList = new ArrayList<TnIdentifierGenerator>();
                this._internalIdentifierGeneratorsByPropertyName = TnBeanMetaDataFactoryExtension.this.newConcurrentHashMap();
            }

            public void initialize() {
                TnBeanMetaData cachedMeta;
                Class<?> myBeanClass = this.getBeanClass();
                if (TnBeanMetaDataFactoryExtension.this.isDBFluteEntity(myBeanClass) && (cachedMeta = TnBeanMetaDataFactoryExtension.this.getMetaFromCache(myBeanClass)) == null) {
                    if (TnBeanMetaDataFactoryExtension.this.isInternalDebugEnabled()) {
                        _log.debug((Object)("...Caching the bean: " + DfTypeUtil.toClassTitle(myBeanClass)));
                    }
                    TnBeanMetaDataFactoryExtension.this._metaMap.put(myBeanClass, this);
                }
                super.initialize();
            }

            protected void setupIdentifierGenerator(TnPropertyType propertyType) {
                DfPropertyDesc pd = propertyType.getPropertyDesc();
                String propertyName = propertyType.getPropertyName();
                String idType = this._beanAnnotationReader.getId(pd);
                TnIdentifierGenerator generator = this.createInternalIdentifierGenerator(propertyType, idType);
                this._internalIdentifierGeneratorList.add(generator);
                this._internalIdentifierGeneratorsByPropertyName.put(propertyName, generator);
            }

            protected TnIdentifierGenerator createInternalIdentifierGenerator(TnPropertyType propertyType, String idType) {
                return TnIdentifierGeneratorFactory.createIdentifierGenerator(propertyType, idType);
            }

            public TnIdentifierGenerator getIdentifierGenerator(int index) {
                return this._internalIdentifierGeneratorList.get(index);
            }

            public int getIdentifierGeneratorSize() {
                return this._internalIdentifierGeneratorList.size();
            }

            public TnIdentifierGenerator getIdentifierGenerator(String propertyName) {
                return this._internalIdentifierGeneratorsByPropertyName.get(propertyName);
            }
        };
    }

    @Override
    protected int getLimitRelationNestLevel() {
        return 2;
    }

    protected boolean isDBFluteEntity(Class<?> beanClass) {
        return Entity.class.isAssignableFrom(beanClass);
    }

    protected TnBeanMetaData getMetaFromCache(Class<?> beanClass) {
        return this._metaMap.get(beanClass);
    }

    private boolean isInternalDebugEnabled() {
        return ResourceContext.isInternalDebug() && _log.isDebugEnabled();
    }

    protected <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }
}

