/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SortableDoubleFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.util.NumberUtils;

public class SortableDoubleField
extends PrimitiveFieldType {
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource(qparser);
        return new SortableDoubleFieldSource(field.name);
    }

    public String toInternal(String val) {
        return NumberUtils.double2sortableStr(val);
    }

    public String toExternal(Fieldable f) {
        return this.indexedToReadable(f.stringValue());
    }

    public Double toObject(Fieldable f) {
        return NumberUtils.SortableStr2double(f.stringValue());
    }

    public String indexedToReadable(String indexedForm) {
        return NumberUtils.SortableStr2doubleStr(indexedForm);
    }

    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        String sval = f.stringValue();
        xmlWriter.writeDouble(name, NumberUtils.SortableStr2double(sval));
    }

    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        String sval = f.stringValue();
        writer.writeDouble(name, NumberUtils.SortableStr2double(sval));
    }
}

