/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.ReaderUtil;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReaderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrIndexReader
extends FilterIndexReader {
    private final SolrIndexReader[] subReaders;
    private final SolrIndexReader[] leafReaders;
    private int[] leafOffsets;
    private final SolrIndexReader parent;
    private final int base;
    private static int[] zeroIntArray = new int[]{0};
    SolrIndexSearcher searcher;
    private SolrReaderInfo info;

    public SolrIndexReader(IndexReader in, SolrIndexReader parent, int base) {
        super(in);
        assert (!(in instanceof SolrIndexReader));
        this.parent = parent;
        this.base = base;
        IndexReader[] subs = in.getSequentialSubReaders();
        if (subs != null) {
            this.subReaders = new SolrIndexReader[subs.length];
            int numLeaves = subs.length;
            this.leafOffsets = new int[numLeaves];
            int b = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                SolrIndexReader sir = this.subReaders[i] = new SolrIndexReader(subs[i], this, b);
                this.leafOffsets[i] = b;
                b += sir.maxDoc();
                SolrIndexReader[] subLeaves = sir.leafReaders;
                numLeaves += subLeaves.length - 1;
            }
            this.leafReaders = this.getLeaves(numLeaves);
        } else {
            this.subReaders = null;
            this.leafReaders = new SolrIndexReader[]{this};
            this.leafOffsets = zeroIntArray;
        }
    }

    private SolrIndexReader[] getLeaves(int numLeaves) {
        if (this.subReaders == null || numLeaves == this.subReaders.length) {
            return this.subReaders;
        }
        SolrIndexReader[] leaves = new SolrIndexReader[numLeaves];
        this.leafOffsets = new int[numLeaves];
        int i = 0;
        int b = 0;
        for (SolrIndexReader sir : this.subReaders) {
            SolrIndexReader[] subLeaves = sir.leafReaders;
            if (subLeaves == null) {
                this.leafOffsets[i] = b;
                b += sir.maxDoc();
                leaves[i++] = sir;
                continue;
            }
            for (SolrIndexReader subLeaf : subLeaves) {
                this.leafOffsets[i] = b;
                b += subLeaf.maxDoc();
                leaves[i++] = subLeaf;
            }
        }
        assert (i == numLeaves && b == this.maxDoc());
        return leaves;
    }

    public SolrIndexReader[] getLeafReaders() {
        return this.leafReaders;
    }

    public int[] getLeafOffsets() {
        return this.leafOffsets;
    }

    public static int readerIndex(int doc, int[] offsets) {
        int high = offsets.length - 1;
        if (high <= 0 || doc < offsets[1]) {
            return 0;
        }
        int low = 1;
        while (high >= low) {
            int mid = low + high >>> 1;
            int offset = offsets[mid];
            if (doc < offset) {
                high = mid - 1;
                continue;
            }
            if (doc > offset) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return high;
    }

    static String shortName(Object o) {
        return o.getClass().getSimpleName() + "@" + Integer.toHexString(o.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SolrIndexReader{this=").append(Integer.toHexString(this.hashCode()));
        sb.append(",r=").append(SolrIndexReader.shortName(this.in));
        sb.append(",refCnt=").append(this.getRefCount());
        sb.append(",segments=");
        sb.append(this.subReaders == null ? 1 : this.subReaders.length);
        if (this.parent != null) {
            sb.append(",parent=").append(this.parent.toString());
        }
        sb.append('}');
        return sb.toString();
    }

    static void setSearcher(SolrIndexReader sr, SolrIndexSearcher searcher) {
        sr.searcher = searcher;
        SolrIndexReader[] readers = sr.getSequentialSubReaders();
        if (readers == null) {
            return;
        }
        for (SolrIndexReader r : readers) {
            SolrIndexReader.setSearcher(r, searcher);
        }
    }

    private static void buildInfoMap(SolrIndexReader other, HashMap<IndexReader, SolrReaderInfo> map) {
        if (other == null) {
            return;
        }
        map.put(other.getWrappedReader(), other.info);
        SolrIndexReader[] readers = other.getSequentialSubReaders();
        if (readers == null) {
            return;
        }
        for (SolrIndexReader r : readers) {
            SolrIndexReader.buildInfoMap(r, map);
        }
    }

    private static void setInfo(SolrIndexReader target, HashMap<IndexReader, SolrReaderInfo> map) {
        SolrReaderInfo info = map.get(target.getWrappedReader());
        if (info == null) {
            info = new SolrReaderInfo(target.getWrappedReader());
        }
        target.info = info;
        SolrIndexReader[] readers = target.getSequentialSubReaders();
        if (readers == null) {
            return;
        }
        for (SolrIndexReader r : readers) {
            SolrIndexReader.setInfo(r, map);
        }
    }

    public void associateInfo(SolrIndexReader source) {
        HashMap<IndexReader, SolrReaderInfo> map = new HashMap<IndexReader, SolrReaderInfo>();
        SolrIndexReader.buildInfoMap(source, map);
        SolrIndexReader.setInfo(this, map);
    }

    public IndexReader getWrappedReader() {
        return this.in;
    }

    public SolrIndexReader getParent() {
        return this.parent;
    }

    public int getBase() {
        return this.base;
    }

    public Directory directory() {
        return this.in.directory();
    }

    public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
        return this.in.getTermFreqVectors(docNumber);
    }

    public TermFreqVector getTermFreqVector(int docNumber, String field) throws IOException {
        return this.in.getTermFreqVector(docNumber, field);
    }

    public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
        this.in.getTermFreqVector(docNumber, field, mapper);
    }

    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.in.getTermFreqVector(docNumber, mapper);
    }

    public int numDocs() {
        return this.in.numDocs();
    }

    public int maxDoc() {
        return this.in.maxDoc();
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        return this.in.document(n, fieldSelector);
    }

    public boolean isDeleted(int n) {
        return this.in.isDeleted(n);
    }

    public boolean hasDeletions() {
        return this.in.hasDeletions();
    }

    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        this.in.undeleteAll();
    }

    public boolean hasNorms(String field) throws IOException {
        return this.in.hasNorms(field);
    }

    public byte[] norms(String f) throws IOException {
        return this.in.norms(f);
    }

    public void norms(String f, byte[] bytes, int offset) throws IOException {
        this.in.norms(f, bytes, offset);
    }

    protected void doSetNorm(int d, String f, byte b) throws CorruptIndexException, IOException {
        this.in.setNorm(d, f, b);
    }

    public TermEnum terms() throws IOException {
        return this.in.terms();
    }

    public TermEnum terms(Term t) throws IOException {
        return this.in.terms(t);
    }

    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        return this.in.docFreq(t);
    }

    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return this.in.termDocs();
    }

    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        return this.in.termDocs(term);
    }

    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return this.in.termPositions();
    }

    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.in.deleteDocument(n);
    }

    protected void doClose() throws IOException {
        this.in.close();
    }

    public FieldInfos getFieldInfos() {
        return ReaderUtil.getMergedFieldInfos((IndexReader)this.in);
    }

    public long getVersion() {
        return this.in.getVersion();
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        return this.in.isCurrent();
    }

    public boolean isOptimized() {
        return this.in.isOptimized();
    }

    public SolrIndexReader[] getSequentialSubReaders() {
        return this.subReaders;
    }

    public int hashCode() {
        return this.in.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SolrIndexReader) {
            o = ((SolrIndexReader)((Object)o)).in;
        }
        return this.in.equals(o);
    }

    public IndexReader reopen(IndexCommit commit) throws CorruptIndexException, IOException {
        return this.in.reopen(commit);
    }

    public Object clone() {
        return super.clone();
    }

    public IndexReader clone(boolean openReadOnly) throws CorruptIndexException, IOException {
        return super.clone(openReadOnly);
    }

    public Map getCommitUserData() {
        return this.in.getCommitUserData();
    }

    public long getUniqueTermCount() throws IOException {
        return super.getUniqueTermCount();
    }

    public SolrIndexReader reopen(boolean openReadOnly) throws IOException {
        IndexReader r = this.in.reopen(openReadOnly);
        if (r == this.in) {
            return this;
        }
        SolrIndexReader sr = new SolrIndexReader(r, null, 0);
        sr.associateInfo(this);
        return sr;
    }

    public SolrIndexReader reopen() throws CorruptIndexException, IOException {
        return this.reopen(true);
    }

    public IndexCommit getIndexCommit() throws IOException {
        return this.in.getIndexCommit();
    }

    public Object getCoreCacheKey() {
        return this.in.getCoreCacheKey();
    }

    public int getTermInfosIndexDivisor() {
        return this.in.getTermInfosIndexDivisor();
    }
}

