/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.SystemPropertiesRestoreRule;
import org.apache.noggit.CharArr;
import org.apache.noggit.JSONUtil;
import org.apache.noggit.ObjectBuilder;
import org.apache.solr.JSONTestUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.JsonUpdateRequestHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.servlet.DirectSolrConnection;
import org.apache.solr.util.TestHarness;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SolrTestCaseJ4
extends LuceneTestCase {
    @ClassRule
    public static TestRule solrClassRules = RuleChain.outerRule((TestRule)new SystemPropertiesRestoreRule());
    @Rule
    public TestRule solrTestRules = RuleChain.outerRule((TestRule)new SystemPropertiesRestoreRule());
    static long numOpens;
    static long numCloses;
    protected static String configString;
    protected static String schemaString;
    protected static SolrConfig solrConfig;
    protected static TestHarness h;
    protected static TestHarness.LocalRequestFactory lrf;
    protected static File dataDir;
    public static Logger log;
    private static String factoryProp;
    public static final IRange ZERO_ONE;
    public static final IRange ZERO_TWO;
    public static final IRange ONE_ONE;

    @BeforeClass
    public static void beforeClassSolrTestCase() throws Exception {
        SolrTestCaseJ4.startTrackingSearchers();
        SolrTestCaseJ4.ignoreException("ignore_exception");
    }

    @AfterClass
    public static void afterClassSolrTestCase() throws Exception {
        SolrTestCaseJ4.deleteCore();
        SolrTestCaseJ4.resetExceptionIgnores();
        SolrTestCaseJ4.endTrackingSearchers();
    }

    public static void closeDirectories() throws Exception {
        for (MockDirectoryWrapper d : stores.keySet()) {
            if (!d.isOpen()) continue;
            d.close();
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        log.info("###Starting " + this.getName());
    }

    public void tearDown() throws Exception {
        log.info("###Ending " + this.getName());
        super.tearDown();
    }

    public static void initCore(String config, String schema) throws Exception {
        SolrTestCaseJ4.initCore(config, schema, SolrTestCaseJ4.TEST_HOME());
    }

    public static void initCore(String config, String schema, String solrHome) throws Exception {
        configString = config;
        schemaString = schema;
        if (solrHome != null) {
            System.setProperty("solr.solr.home", solrHome);
        }
        SolrTestCaseJ4.initCore();
    }

    public static void startTrackingSearchers() {
        numOpens = SolrIndexSearcher.numOpens.get();
        numCloses = SolrIndexSearcher.numCloses.get();
    }

    public static void endTrackingSearchers() {
        long endNumOpens = SolrIndexSearcher.numOpens.get();
        long endNumCloses = SolrIndexSearcher.numCloses.get();
        SolrIndexSearcher.numOpens.getAndSet(0L);
        SolrIndexSearcher.numCloses.getAndSet(0L);
        if (endNumOpens - numOpens != endNumCloses - numCloses) {
            String msg = "ERROR: SolrIndexSearcher opens=" + (endNumOpens - numOpens) + " closes=" + (endNumCloses - numCloses);
            log.error(msg);
            testsFailed = true;
            SolrTestCaseJ4.fail((String)msg);
        }
    }

    public static void ignoreException(String pattern) {
        if (SolrException.ignorePatterns == null) {
            SolrException.ignorePatterns = new HashSet();
        }
        SolrException.ignorePatterns.add(pattern);
    }

    public static void resetExceptionIgnores() {
        SolrException.ignorePatterns = null;
        SolrTestCaseJ4.ignoreException("ignore_exception");
    }

    protected static String getClassName() {
        return SolrTestCaseJ4.getTestClass().getName();
    }

    protected static String getSimpleClassName() {
        return SolrTestCaseJ4.getTestClass().getSimpleName();
    }

    public static String getSchemaFile() {
        return schemaString;
    }

    public static String getSolrConfigFile() {
        return configString;
    }

    public static void createTempDir() {
        String cname = SolrTestCaseJ4.getSimpleClassName();
        dataDir = new File(TEMP_DIR, "solrtest-" + cname + "-" + System.currentTimeMillis());
        dataDir.mkdirs();
    }

    public static void initCore() throws Exception {
        log.info("####initCore");
        SolrTestCaseJ4.ignoreException("ignore_exception");
        factoryProp = System.getProperty("solr.directoryFactory");
        if (factoryProp == null) {
            System.setProperty("solr.directoryFactory", "solr.RAMDirectoryFactory");
        }
        if (dataDir == null) {
            SolrTestCaseJ4.createTempDir();
        }
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        String configFile = SolrTestCaseJ4.getSolrConfigFile();
        if (configFile != null) {
            solrConfig = TestHarness.createConfig(SolrTestCaseJ4.getSolrConfigFile());
            h = new TestHarness(dataDir.getAbsolutePath(), solrConfig, SolrTestCaseJ4.getSchemaFile());
            lrf = h.getRequestFactory("standard", 0, 20, "version", "2.2");
        }
        log.info("####initCore end");
    }

    public void postSetUp() {
        log.info("####POSTSETUP " + this.getName());
    }

    public void preTearDown() {
        log.info("####PRETEARDOWN " + this.getName());
    }

    public static void deleteCore() throws Exception {
        log.info("###deleteCore");
        if (h != null) {
            h.close();
        }
        SolrTestCaseJ4.closeDirectories();
        if (dataDir != null) {
            String skip = System.getProperty("solr.test.leavedatadir");
            if (null != skip && 0 != skip.trim().length()) {
                System.err.println("NOTE: per solr.test.leavedatadir, dataDir will not be removed: " + dataDir.getAbsolutePath());
            } else if (!SolrTestCaseJ4.recurseDelete(dataDir)) {
                System.err.println("!!!! WARNING: best effort to remove " + dataDir.getAbsolutePath() + " FAILED !!!!!");
            }
        }
        if (factoryProp == null) {
            System.clearProperty("solr.directoryFactory");
        }
        dataDir = null;
        solrConfig = null;
        h = null;
        lrf = null;
        schemaString = null;
        configString = null;
    }

    public static void assertU(String update) {
        SolrTestCaseJ4.assertU(null, update);
    }

    public static void assertU(String message, String update) {
        SolrTestCaseJ4.checkUpdateU(message, update, true);
    }

    public static void assertFailedU(String update) {
        SolrTestCaseJ4.assertFailedU(null, update);
    }

    public static void assertFailedU(String message, String update) {
        SolrTestCaseJ4.checkUpdateU(message, update, false);
    }

    private static void checkUpdateU(String message, String update, boolean shouldSucceed) {
        try {
            String m;
            String string = m = null == message ? "" : message + " ";
            if (shouldSucceed) {
                String res = h.validateUpdate(update);
                if (res != null) {
                    SolrTestCaseJ4.fail((String)(m + "update was not successful: " + res));
                }
            } else {
                String res = h.validateErrorUpdate(update);
                if (res != null) {
                    SolrTestCaseJ4.fail((String)(m + "update succeeded, but should have failed: " + res));
                }
            }
        }
        catch (SAXException e) {
            throw new RuntimeException("Invalid XML", e);
        }
    }

    public static void assertQ(SolrQueryRequest req, String ... tests) {
        SolrTestCaseJ4.assertQ(null, req, tests);
    }

    public static void assertQ(String message, SolrQueryRequest req, String ... tests) {
        try {
            String results;
            String m = null == message ? "" : message + " ";
            String response = h.query(req);
            if (req.getParams().getBool("facet", false)) {
                String[] allTests = new String[tests.length + 1];
                System.arraycopy(tests, 0, allTests, 1, tests.length);
                allTests[0] = "*[count(//lst[@name='facet_counts']/*[@name='exception'])=0]";
                tests = allTests;
            }
            if (null != (results = h.validateXPath(response, tests))) {
                String msg = "REQUEST FAILED: xpath=" + results + "\n\txml response was: " + response + "\n\trequest was:" + req.getParamString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
        }
        catch (XPathExpressionException e1) {
            throw new RuntimeException("XPath is invalid", e1);
        }
        catch (Exception e2) {
            SolrException.log((Logger)log, (String)("REQUEST FAILED: " + req.getParamString()), (Throwable)e2);
            throw new RuntimeException("Exception during query", e2);
        }
    }

    public static void assertJQ(SolrQueryRequest req, String ... tests) throws Exception {
        SolrTestCaseJ4.assertJQ(req, 1.0E-5, tests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertJQ(SolrQueryRequest req, double delta, String ... tests) throws Exception {
        SolrParams params = null;
        try {
            String response;
            params = req.getParams();
            if (!"json".equals(params.get("wt", "xml")) || params.get("indent") == null) {
                ModifiableSolrParams newParams = new ModifiableSolrParams(params);
                newParams.set("wt", new String[]{"json"});
                if (params.get("indent") == null) {
                    newParams.set("indent", new String[]{"true"});
                }
                req.setParams((SolrParams)newParams);
            }
            boolean failed = true;
            try {
                response = h.query(req);
                failed = false;
            }
            finally {
                if (failed) {
                    log.error("REQUEST FAILED: " + req.getParamString());
                }
            }
            for (String test : tests) {
                if (test == null || test.length() == 0) continue;
                String testJSON = test.replace('\'', '\"');
                try {
                    failed = true;
                    String err = JSONTestUtil.match(response, testJSON, delta);
                    failed = false;
                    if (err == null) continue;
                    log.error("query failed JSON validation. error=" + err + "\n expected =" + testJSON + "\n response = " + response + "\n request = " + req.getParamString());
                    throw new RuntimeException(err);
                }
                finally {
                    if (failed) {
                        log.error("JSON query validation threw an exception.\n expected =" + testJSON + "\n response = " + response + "\n request = " + req.getParamString());
                    }
                }
            }
        }
        finally {
            if (params != null && params != req.getParams()) {
                req.setParams(params);
            }
        }
    }

    public static void assertQEx(String message, SolrQueryRequest req, int code) {
        try {
            h.query(req);
            SolrTestCaseJ4.fail((String)message);
        }
        catch (SolrException sex) {
            SolrTestCaseJ4.assertEquals((long)code, (long)sex.code());
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception during query", e2);
        }
    }

    public static void assertQEx(String message, SolrQueryRequest req, SolrException.ErrorCode code) {
        try {
            h.query(req);
            SolrTestCaseJ4.fail((String)message);
        }
        catch (SolrException e) {
            SolrTestCaseJ4.assertEquals((long)code.code, (long)e.code());
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception during query", e2);
        }
    }

    public static String optimize(String ... args) {
        return TestHarness.optimize(args);
    }

    public static String commit(String ... args) {
        return TestHarness.commit(args);
    }

    public static String adoc(String ... fieldsAndValues) {
        XmlDoc d = SolrTestCaseJ4.doc(fieldsAndValues);
        return SolrTestCaseJ4.add(d, new String[0]);
    }

    public static String adoc(SolrInputDocument sdoc) {
        ArrayList<String> fields = new ArrayList<String>();
        for (SolrInputField sf : sdoc) {
            for (Object o : sf.getValues()) {
                fields.add(sf.getName());
                fields.add(o.toString());
            }
        }
        return SolrTestCaseJ4.adoc(fields.toArray(new String[fields.size()]));
    }

    public static String add(XmlDoc doc, String ... args) {
        try {
            StringWriter r = new StringWriter();
            if (null == args || 0 == args.length) {
                r.write("<add>");
                r.write(doc.xml);
                r.write("</add>");
            } else {
                XML.writeUnescapedXML((Writer)r, (String)"add", (String)doc.xml, (Object[])args);
            }
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String delI(String id) {
        return TestHarness.deleteById(id, new String[0]);
    }

    public static String delQ(String q) {
        return TestHarness.deleteByQuery(q, new String[0]);
    }

    public static XmlDoc doc(String ... fieldsAndValues) {
        XmlDoc d = new XmlDoc();
        d.xml = TestHarness.makeSimpleDoc(fieldsAndValues).toString();
        return d;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    public static SolrQueryRequest req(String ... q) {
        return lrf.makeRequest(q);
    }

    public static SolrQueryRequest req(String[] params, String ... moreParams) {
        String[] allParams = moreParams;
        if (params.length != 0) {
            int len = params.length + moreParams.length;
            allParams = new String[len];
            System.arraycopy(params, 0, allParams, 0, params.length);
            System.arraycopy(moreParams, 0, allParams, params.length, moreParams.length);
        }
        return lrf.makeRequest(allParams);
    }

    public static SolrQueryRequest req(SolrParams params, String ... moreParams) {
        ModifiableSolrParams mp = new ModifiableSolrParams(params);
        for (int i = 0; i < moreParams.length; i += 2) {
            mp.add(moreParams[i], new String[]{moreParams[i + 1]});
        }
        return new LocalSolrQueryRequest(h.getCore(), (SolrParams)mp);
    }

    public static boolean recurseDelete(File f) {
        if (f.isDirectory()) {
            for (File sub : f.listFiles()) {
                if (SolrTestCaseJ4.recurseDelete(sub)) continue;
                System.err.println("!!!! WARNING: best effort to remove " + sub.getAbsolutePath() + " FAILED !!!!!");
                return false;
            }
        }
        return f.delete();
    }

    public void clearIndex() {
        SolrTestCaseJ4.assertU(SolrTestCaseJ4.delQ("*:*"));
    }

    public static String updateJ(String json, SolrParams args) throws Exception {
        SolrCore core = h.getCore();
        DirectSolrConnection connection = new DirectSolrConnection(core);
        SolrRequestHandler handler = core.getRequestHandler("/update/json");
        if (handler == null) {
            handler = new JsonUpdateRequestHandler();
            handler.init(null);
        }
        return connection.request(handler, args, json);
    }

    public Map<Comparable, Doc> indexDocs(List<FldType> descriptor, Map<Comparable, Doc> model, int nDocs) throws Exception {
        if (model == null) {
            model = new LinkedHashMap<Comparable, Doc>();
        }
        int commitOneOutOf = Math.max(nDocs / 10, 10);
        for (int i = 0; i < nDocs; ++i) {
            Doc doc = SolrTestCaseJ4.createDoc(descriptor);
            SolrTestCaseJ4.updateJ(SolrTestCaseJ4.toJSON(doc), null);
            model.put(doc.id, doc);
            if (random.nextInt(commitOneOutOf) == 0) {
                SolrTestCaseJ4.assertU(SolrTestCaseJ4.commit(new String[0]));
            }
            if (random.nextInt(10) != 0) continue;
            SolrTestCaseJ4.updateJ(SolrTestCaseJ4.toJSON(doc), null);
            model.put(doc.id, doc);
        }
        if (random.nextInt(10) == 0) {
            SolrTestCaseJ4.assertU(SolrTestCaseJ4.optimize(new String[0]));
        } else {
            SolrTestCaseJ4.assertU(SolrTestCaseJ4.commit(new String[0]));
        }
        String responseStr = h.query(SolrTestCaseJ4.req("q", "*:*", "fl", "id", "sort", "_docid_ asc", "rows", Integer.toString(model.size() * 2), "wt", "json", "indent", "true"));
        Object response = ObjectBuilder.fromJSON((String)responseStr);
        response = ((Map)response).get("response");
        response = ((Map)response).get("docs");
        List docList = (List)response;
        int order = 0;
        for (Map doc : docList) {
            Object id = doc.get("id");
            Doc modelDoc = model.get(id);
            if (modelDoc == null) continue;
            modelDoc.order = order++;
        }
        SolrTestCaseJ4.assertEquals((long)order, (long)model.size());
        return model;
    }

    public static Doc createDoc(List<FldType> descriptor) {
        Doc doc = new Doc();
        doc.fields = new ArrayList<Fld>();
        for (FldType ftype : descriptor) {
            Fld fld = ftype.createField();
            if (fld == null) continue;
            doc.fields.add(fld);
            if (!"id".equals(ftype.fname)) continue;
            doc.id = fld.vals.get(0);
        }
        return doc;
    }

    public static Comparator<Doc> createSort(IndexSchema schema, List<FldType> fieldTypes, String[] out) {
        StringBuilder sortSpec = new StringBuilder();
        int nSorts = random.nextInt(4);
        ArrayList<Comparator<Doc>> comparators = new ArrayList<Comparator<Doc>>();
        for (int i = 0; i < nSorts; ++i) {
            if (i > 0) {
                sortSpec.append(',');
            }
            int which = random.nextInt(fieldTypes.size() + 2);
            boolean asc = random.nextBoolean();
            if (which == fieldTypes.size()) {
                sortSpec.append("score").append(asc ? " asc" : " desc");
                comparators.add(SolrTestCaseJ4.createComparator("score", asc, false, false, false));
                continue;
            }
            if (which == fieldTypes.size() + 1) {
                sortSpec.append("_docid_").append(asc ? " asc" : " desc");
                comparators.add(SolrTestCaseJ4.createComparator("_docid_", asc, false, false, false));
                continue;
            }
            String field = fieldTypes.get((int)which).fname;
            sortSpec.append(field).append(asc ? " asc" : " desc");
            SchemaField sf = schema.getField(field);
            comparators.add(SolrTestCaseJ4.createComparator(field, asc, sf.sortMissingLast(), sf.sortMissingFirst(), !sf.sortMissingLast() && !sf.sortMissingFirst()));
        }
        String string = out[0] = sortSpec.length() > 0 ? sortSpec.toString() : null;
        if (comparators.size() == 0) {
            comparators.add(SolrTestCaseJ4.createComparator("score", false, false, false, false));
        }
        return SolrTestCaseJ4.createComparator(comparators);
    }

    public static Comparator<Doc> createComparator(final String field, boolean asc, final boolean sortMissingLast, final boolean sortMissingFirst, boolean sortMissingAsZero) {
        int mul;
        int n = mul = asc ? 1 : -1;
        if (field.equals("_docid_")) {
            return new Comparator<Doc>(){

                @Override
                public int compare(Doc o1, Doc o2) {
                    return (o1.order - o2.order) * mul;
                }
            };
        }
        if (field.equals("score")) {
            return SolrTestCaseJ4.createComparator("score_f", asc, sortMissingLast, sortMissingFirst, sortMissingAsZero);
        }
        return new Comparator<Doc>(){

            private Comparable zeroVal(Comparable template) {
                if (template == null) {
                    return null;
                }
                if (template instanceof String) {
                    return null;
                }
                if (template instanceof Integer) {
                    return Integer.valueOf(0);
                }
                if (template instanceof Long) {
                    return Long.valueOf(0L);
                }
                if (template instanceof Float) {
                    return Float.valueOf(0.0f);
                }
                if (template instanceof Double) {
                    return Double.valueOf(0.0);
                }
                if (template instanceof Short) {
                    return Short.valueOf((short)0);
                }
                if (template instanceof Byte) {
                    return Byte.valueOf((byte)0);
                }
                if (template instanceof Character) {
                    return Character.valueOf('\u0000');
                }
                return null;
            }

            @Override
            public int compare(Doc o1, Doc o2) {
                Comparable v1 = o1.getFirstValue(field);
                Comparable v2 = o2.getFirstValue(field);
                v1 = v1 == null ? this.zeroVal(v2) : v1;
                v2 = v2 == null ? this.zeroVal(v1) : v2;
                int c = 0;
                c = v1 == v2 ? 0 : (v1 == null ? (sortMissingLast ? mul : (sortMissingFirst ? -mul : -1)) : (v2 == null ? (sortMissingLast ? -mul : (sortMissingFirst ? mul : 1)) : v1.compareTo(v2)));
                return c *= mul;
            }
        };
    }

    public static Comparator<Doc> createComparator(final List<Comparator<Doc>> comparators) {
        return new Comparator<Doc>(){

            @Override
            public int compare(Doc o1, Doc o2) {
                int c = 0;
                for (Comparator comparator : comparators) {
                    c = comparator.compare(o1, o2);
                    if (c == 0) continue;
                    return c;
                }
                return o1.order - o2.order;
            }
        };
    }

    public static String toJSON(Doc doc) {
        CharArr out = new CharArr();
        try {
            out.append((CharSequence)"{\"add\":{\"doc\":{");
            boolean firstField = true;
            for (Fld fld : doc.fields) {
                if (firstField) {
                    firstField = false;
                } else {
                    out.append(',');
                }
                JSONUtil.writeString((CharSequence)fld.ftype.fname, (int)0, (int)fld.ftype.fname.length(), (CharArr)out);
                out.append(':');
                if (fld.vals.size() > 1) {
                    out.append('[');
                }
                boolean firstVal = true;
                for (Comparable val : fld.vals) {
                    if (firstVal) {
                        firstVal = false;
                    } else {
                        out.append(',');
                    }
                    out.append((CharSequence)JSONUtil.toJSON((Object)val));
                }
                if (fld.vals.size() <= 1) continue;
                out.append(']');
            }
            out.append((CharSequence)"}}}");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    Map<Comparable, List<Comparable>> invertField(Map<Comparable, Doc> model, String field) {
        HashMap<Comparable, List<Comparable>> value_to_id = new HashMap<Comparable, List<Comparable>>();
        for (Comparable key : model.keySet()) {
            Doc doc = model.get(key);
            List<Comparable> vals = doc.getValues(field);
            if (vals == null) continue;
            for (Comparable val : vals) {
                ArrayList<Comparable> ids = (ArrayList<Comparable>)value_to_id.get(val);
                if (ids == null) {
                    ids = new ArrayList<Comparable>(2);
                    value_to_id.put(val, ids);
                }
                ids.add(key);
            }
        }
        return value_to_id;
    }

    public static File getFile(String name) {
        try {
            File file = new File(name);
            if (!file.exists()) {
                file = new File(Thread.currentThread().getContextClassLoader().getResource(name).toURI());
            }
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot find resource: " + name);
        }
    }

    public static String TEST_HOME() {
        return SolrTestCaseJ4.getFile("solr/conf").getParent();
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable result = t;
        for (Throwable cause = t; null != cause; cause = cause.getCause()) {
            result = cause;
        }
        return result;
    }

    static {
        log = LoggerFactory.getLogger(SolrTestCaseJ4.class);
        ZERO_ONE = new IRange(0, 1);
        ZERO_TWO = new IRange(0, 2);
        ONE_ONE = new IRange(1, 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FldType {
        public String fname;
        public IRange numValues;
        public Vals vals;

        public FldType(String fname, Vals vals) {
            this(fname, ZERO_ONE, vals);
        }

        public FldType(String fname, IRange numValues, Vals vals) {
            this.fname = fname;
            this.numValues = numValues;
            this.vals = vals;
        }

        public Comparable createValue() {
            return this.vals.get();
        }

        public List<Comparable> createValues() {
            int nVals = this.numValues.getInt();
            if (nVals <= 0) {
                return null;
            }
            ArrayList<Comparable> vals = new ArrayList<Comparable>(nVals);
            for (int i = 0; i < nVals; ++i) {
                vals.add(this.createValue());
            }
            return vals;
        }

        public Fld createField() {
            List<Comparable> vals = this.createValues();
            if (vals == null) {
                return null;
            }
            Fld fld = new Fld();
            fld.ftype = this;
            fld.vals = vals;
            return fld;
        }
    }

    public static class Fld {
        public FldType ftype;
        public List<Comparable> vals;

        public String toString() {
            return this.ftype.fname + "=" + (this.vals.size() == 1 ? this.vals.get(0).toString() : this.vals.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Doc
    implements Comparable {
        public Comparable id;
        public List<Fld> fields;
        public int order;

        public String toString() {
            return "Doc(" + this.order + "):" + this.fields.toString();
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Doc)) {
                return false;
            }
            Doc other = (Doc)o;
            return this == other || this.id != null && this.id.equals(other.id);
        }

        public int compareTo(Object o) {
            if (!(o instanceof Doc)) {
                return this.getClass().hashCode() - o.getClass().hashCode();
            }
            Doc other = (Doc)o;
            return this.id.compareTo(other.id);
        }

        public List<Comparable> getValues(String field) {
            for (Fld fld : this.fields) {
                if (!fld.ftype.fname.equals(field)) continue;
                return fld.vals;
            }
            return null;
        }

        public Comparable getFirstValue(String field) {
            List<Comparable> vals = this.getValues(field);
            return vals == null || vals.size() == 0 ? null : vals.get(0);
        }

        public Map<String, Object> toObject(IndexSchema schema) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Fld fld : this.fields) {
                SchemaField sf = schema.getField(fld.ftype.fname);
                if (!sf.multiValued()) {
                    result.put(fld.ftype.fname, fld.vals.get(0));
                    continue;
                }
                result.put(fld.ftype.fname, fld.vals);
            }
            return result;
        }
    }

    public static class SVal
    extends Vals {
        char start;
        char end;
        int minLength;
        int maxLength;

        public SVal() {
            this('a', 'z', 1, 10);
        }

        public SVal(char start, char end, int minLength, int maxLength) {
            this.start = start;
            this.end = end;
            this.minLength = minLength;
            this.maxLength = maxLength;
        }

        public Comparable get() {
            char[] arr = new char[this.between(this.minLength, this.maxLength)];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (char)this.between(this.start, this.end);
            }
            return new String(arr);
        }
    }

    public static class FVal
    extends Vals {
        final float min;
        final float max;

        public FVal(float min, float max) {
            this.min = min;
            this.max = max;
        }

        public float getFloat() {
            if (this.min >= this.max) {
                return this.min;
            }
            return this.min + random.nextFloat() * (this.max - this.min);
        }

        public Comparable get() {
            return Float.valueOf(this.getFloat());
        }
    }

    public static class IRange
    extends IVals {
        final int min;
        final int max;

        public IRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getInt() {
            return this.between(this.min, this.max);
        }

        public Comparable get() {
            return Integer.valueOf(this.getInt());
        }
    }

    public static abstract class IVals
    extends Vals {
        public abstract int getInt();
    }

    public static abstract class Vals {
        public abstract Comparable get();

        public String toJSON(Comparable val) {
            return JSONUtil.toJSON((Object)val);
        }

        protected int between(int min, int max) {
            return min != max ? random.nextInt(max - min + 1) + min : min;
        }
    }

    public static class XmlDoc {
        public String xml;

        public String toString() {
            return this.xml;
        }
    }
}

