/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include "TFK_GUIBase.h"

TFK_GUIBase::TFK_GUIBase(void)
{
	buttonStack.clear();
	textBoxStack.clear();
	buttonBase.clear();
	textBoxBase.clear();
	groupBase.clear();
	return;
}

TFK_GUIBase::~TFK_GUIBase()
{
	buttonStack.clear();
	textBoxStack.clear();
	buttonBase.clear();
	textBoxBase.clear();
	groupBase.clear();
	return;
}

void TFK_GUIBase::createButton(bsize argIndex, bool argFlg)
{
	char				*buffer;
	Fl_Button			*b;
	TFK_ButtonBase		base;

	base = buttonBase[argIndex];
	buffer = new char [base.caption.size()+1];
	strncpy(buffer, base.caption.c_str(), base.caption.size()+1);
	switch(base.type) {
	  case 1:
		b = new Fl_Button(base.x, base.y, base.w, base.h, buffer);
		break;

	  case 2:
		b = new Fl_Return_Button(base.x, base.y, base.w, base.h, buffer);
		break;

	  case 3:
		b = new Fl_Light_Button(base.x, base.y, base.w, base.h, buffer);
		break;

	  case 4:
		b = new Fl_Check_Button(base.x, base.y, base.w, base.h, buffer);
		break;

	  case 5:
		b = new Fl_Round_Button(base.x, base.y, base.w, base.h, buffer);
		break;

	  default:
		delete [] buffer;
		return;
	}
	if(argFlg == true) b->type(FL_RADIO_BUTTON);
	buttonStack[base.id] = b;
	return;
}

void TFK_GUIBase::createTextBox(tsize argIndex)
{
	Fl_Input			*t;
	char				*buffer;
	TFK_TextBoxBase		base;

	base = textBoxBase[argIndex];
	buffer = new char [base.caption.size()+1];
	strncpy(buffer, base.caption.c_str(), base.caption.size()+1);
	t = new Fl_Input(base.x, base.y, base.w, base.h, buffer);
	textBoxStack[base.id] = t;

	return;
}

void TFK_GUIBase::create(void)
{
	gsize			gi;
	bsize			bi;
	tsize			ti;
	TFK_GroupBase	gbase;
	Fl_Group		*group;

	for(gi = 0; gi < groupBase.size(); gi++) {
		gbase = groupBase[gi];
		group = new Fl_Group(gbase.x, gbase.y, gbase.w, gbase.h);
		group->box(FL_THIN_UP_FRAME);

		for(bi = 0; bi < buttonBase.size(); bi++) {
			if(gsize(buttonBase[bi].group) == gi) {
				createButton(bi, true);
			}
		}

		for(ti = 0; ti < textBoxBase.size(); ti++) {
			if(gsize(textBoxBase[ti].group) == gi) {
				createTextBox(ti);
			}
		}

		group->end();
	}

	for(bi = 0; bi < buttonBase.size(); bi++) {
		if(buttonBase[bi].group == -1) {
			createButton(bi, false);
		}
	}

	for(ti = 0; ti < textBoxBase.size(); ti++) {
		if(textBoxBase[ti].group == -1) {
			createTextBox(ti);
		}
	}

	buttonBase.clear();
	textBoxBase.clear();
	groupBase.clear();

	return;
}

void TFK_GUIBase::makeButton(int argID, int argType,
							 int argX, int argY, int argW, int argH,
							 string argCaption)
{
	bsize		i, index;

	index = 0;
	for(i = 0; i < buttonBase.size(); i++) {
		if(buttonBase[i].id == argID) {
			index = i;
			break;
		}
	}
	if(i == buttonBase.size()) {
		index = buttonBase.size();
		buttonBase.resize(buttonBase.size()+1);
	}

	buttonBase[index].id = argID;
	buttonBase[index].type = argType;
	buttonBase[index].x = argX;
	buttonBase[index].y = argY;
	buttonBase[index].w = argW;
	buttonBase[index].h = argH;
	buttonBase[index].caption = argCaption;
	buttonBase[index].group = -1;
	
	return;
}

bool TFK_GUIBase::getButtonStatus(int argID)
{
	if(buttonStack.find(argID) == buttonStack.end()) return false;
	if(buttonStack[argID]->value() == 0) return false;
	return true;
}

void TFK_GUIBase::setButtonStatus(int argID, bool argStatus)
{
	if(buttonStack.find(argID) == buttonStack.end()) return;
	if(argStatus == true) {
		buttonStack[argID]->value(1);
	} else {
		buttonStack[argID]->value(0);
	}
	return;
}

void TFK_GUIBase::makeTextBox(int argID, int argX, int argY,
							 int argW, int argH, string argCaption)
{
	tsize		i, index;

	index = 0;
	for(i = 0; i < textBoxBase.size(); i++) {
		if(textBoxBase[i].id == argID) {
			index = i;
			break;
		}
	}

	if(i == textBoxBase.size()) {
		index = textBoxBase.size();
		textBoxBase.resize(textBoxBase.size()+1);
	}

	textBoxBase[index].id = argID;
	textBoxBase[index].x = argX;
	textBoxBase[index].y = argY;
	textBoxBase[index].w = argW;
	textBoxBase[index].h = argH;
	textBoxBase[index].caption = argCaption;
	textBoxBase[index].group = -1;

	return;
}

string TFK_GUIBase::getTextBoxString(int argID)
{
	string		retStr;

	if(textBoxStack.find(argID) != textBoxStack.end()) {
		retStr = textBoxStack[argID]->value();
	}
	return retStr;
}

void TFK_GUIBase::setTextBoxString(int argID, string argText)
{
	if(textBoxStack.find(argID) != textBoxStack.end()) {
		textBoxStack[argID]->value(argText.c_str());
	}
	return;
}

void TFK_GUIBase::makeGroup(int argID, int argX, int argY,
							int argW, int argH)
{
	gsize		i, index;

	index = 0;
	for(i = 0; i < groupBase.size(); i++) {
		if(groupBase[i].id == argID) {
			index = i;
			break;
		}
	}

	if(i == groupBase.size()) {
		index = groupBase.size();
		groupBase.resize(index+1);
	}

	groupBase[index].id = argID;
	groupBase[index].x = argX;
	groupBase[index].y = argY;
	groupBase[index].w = argW;
	groupBase[index].h = argH;

	return;
}

void TFK_GUIBase::entryButton(int argBID, int argGID)
{
	bsize		bi;
	gsize		gi;

	for(bi = 0; bi < buttonBase.size(); bi++) {
		if(argBID == buttonBase[bi].id) break;
	}
	if(bi == buttonBase.size()) return;

	for(gi = 0; gi < groupBase.size(); gi++) {
		if(argGID == groupBase[gi].id) break;
	}
	if(gi == groupBase.size()) return;

	buttonBase[bi].group = gi;
	return;
}

void TFK_GUIBase::entryTextBox(int argTID, int argGID)
{
	tsize		ti;
	gsize		gi;

	for(ti = 0; ti < textBoxBase.size(); ti++) {
		if(argTID == textBoxBase[ti].id) break;
	}
	if(ti == textBoxBase.size()) return;

	for(gi = 0; gi < groupBase.size(); gi++) {
		if(argGID == groupBase[gi].id) break;
	}
	if(gi == groupBase.size()) return;

	textBoxBase[ti].group = gi;
	return;
}
