/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include "TFK_LineBase.h"

TFK_LineBase::TFK_LineBase(void)
{
	model->setLineColor(0.0f, 0.0f, 0.0f);
	model->setWidth(TFK_DEFAULT_LINE_WIDTH);
	model->setDrawMode(FK_LINEMODE);
	model->setMaterialMode(FK_PARENT_MODE);
	model->setReverseDrawMode(true);
	solid->setMaterialMode(FK_PARENT_MODE);

	defaultWidth = -1.0;

	return;
}

TFK_LineBase::~TFK_LineBase()
{
	delete solid;
	delete model;

	solid = (fk_Solid *)NULL;
	model = (fk_Model *)NULL;

	return;
}

int TFK_LineBase::create(fk_Vector argS, fk_Vector argE)
{
	fk_Vertex	*v1, *v2;
	fk_Edge		*e;

	if(planeMode == true) {
		argS.z = 0.0;
		argE.z = 0.0;
	}

	v1 = solid->makeVertex(argS);
	v2 = solid->makeVertex(argE);
	e = solid->makeEdge(v1, v2);

	if(defaultPalette != TFK_NULL_PALETTE) {
		e->setElemMaterialMode(FK_CHILD_MODE);
		e->setElemMaterialID(defaultPalette);
	}

	if(defaultWidth > 0.0) {
		e->setDrawWidth(defaultWidth);
	}

	return GetMaskID(e->getID());
}

bool TFK_LineBase::move(int argID, fk_Vector argS, fk_Vector argE)
{
	fk_Edge		*edge;
	fk_Vertex	*v1, *v2;

	if(planeMode == true) {
		argS.z = 0.0;
		argE.z = 0.0;
	}

	edge = solid->getEData(GetTrueID(argID));
	if(edge == (fk_Edge *)NULL) return false;
	v1 = solid->getRightVOnE(edge);
	v2 = solid->getLeftVOnE(edge);
	solid->moveVertex(v1, argS);
	solid->moveVertex(v2, argE);
	return true;
}

bool TFK_LineBase::translate(int argID, fk_Vector argVec)
{
	fk_Edge		*edge;
	fk_Vertex	*v1, *v2;
	fk_Vector	v1Pos, v2Pos;

	if(planeMode == true) argVec.z = 0.0;

	edge = solid->getEData(GetTrueID(argID));
	if(edge == (fk_Edge *)NULL) return false;
	v1 = solid->getRightVOnE(edge);
	v2 = solid->getLeftVOnE(edge);
	v1Pos = v1->getPosition();
	v2Pos = v2->getPosition();
	solid->moveVertex(v1, v1Pos + argVec);
	solid->moveVertex(v2, v2Pos + argVec);
	return true;
}

bool TFK_LineBase::clear(int argID)
{
	fk_Edge		*edge;
	fk_Vertex	*v1, *v2;
	int			trueID = GetTrueID(argID);

	if(argID == -1) {
		solid->allClear(false);
		return true;
	}

	if(trueID < 0) return false;

	if((edge = solid->getEData(trueID)) == (fk_Edge *)NULL) return false;
	v1 = solid->getRightVOnE(edge);
	v2 = solid->getLeftVOnE(edge);
	if(solid->deleteEdge(edge) == false) return false;
	solid->deleteVertex(v1);
	solid->deleteVertex(v2);
	return true;
}

bool TFK_LineBase::changePalette(int argID, int argCID)
{
	fk_Edge			*curE;
	int				trueID = GetTrueID(argID);

	if(argID == -1) {
		for(curE = solid->getNextE((fk_Edge *)NULL);
			curE != (fk_Edge *)NULL;
			curE = solid->getNextE(curE)) {
			curE->setElemMaterialMode(FK_CHILD_MODE);
			curE->setElemMaterialID(argCID);
		}
	} else if(trueID < 0) {
		return false;
	} else {
		if((curE = solid->getEData(trueID)) == (fk_Edge *)NULL) {
			return false;
		}
		curE->setElemMaterialMode(FK_CHILD_MODE);
		curE->setElemMaterialID(argCID);
	}
	return true;
}

int TFK_LineBase::getPalette(int argID)
{
	fk_Edge			*edge;

	if((edge = solid->getEData(GetTrueID(argID))) == (fk_Edge *)NULL) {
		return -1;
	}

	return edge->getElemMaterialID();
}

fk_Vector TFK_LineBase::getPos(int argID, int argVID)
{
	fk_Edge		*edge;
	fk_Vertex	*vertex;
	fk_Vector	pos(0.0, 0.0, 0.0);

	if((edge = solid->getEData(GetTrueID(argID))) == (fk_Edge *)NULL) {
		return pos;
	}

	switch(argVID) {
	  case 0:
		vertex = solid->getLeftVOnE(edge);
		return vertex->getPosition();

	  case 1:
		vertex = solid->getRightVOnE(edge);
		return vertex->getPosition();

	  default:
		break;
	}
	return pos;
}

bool TFK_LineBase::isArive(int argID)
{
	return solid->existEdge(GetTrueID(argID));
}

void TFK_LineBase::setWidth(int argID, double argWidth)
{
	fk_Edge		*curE;
	int			trueID = GetTrueID(argID);

	if(argID == -1) {
		for(curE = solid->getNextE((fk_Edge *)NULL);
			curE != (fk_Edge *)NULL;
			curE = solid->getNextE(curE)) {
			curE->setDrawWidth(argWidth);
		}
	} else if(trueID < 0) {
		return;
	} else {
		if((curE = solid->getEData(trueID)) == (fk_Edge *)NULL) {
			return;
		}
		curE->setDrawWidth(argWidth);
	}

	return;
}

double TFK_LineBase::getWidth(int argID)
{
	fk_Edge		*edge;

	if((edge = solid->getEData(GetTrueID(argID))) == (fk_Edge *)NULL) {
		return 0.0;
	}

	return edge->getDrawWidth();
}

void TFK_LineBase::setDefaultWidth(double argWidth)
{
	defaultWidth = argWidth;
	return;
}
