/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __TINY_FK_BASE_SET_HEADER__
#define __TINY_FK_BASE_SET_HEADER__

#include "TFK_PointBase.h"
#include "TFK_LineBase.h"
#include "TFK_PolygonBase.h"
#include "TFK_BlockBase.h"
#include "TFK_SphereBase.h"
#include "TFK_PrismBase.h"
#include "TFK_ConeBase.h"
#include "TFK_FileDataBase.h"
#include "TFK_MeshBase.h"
#include "TFK_TextureBase.h"
#include "TFK_LightBase.h"
#include "TFK_PaletteBase.h"
#include "TFK_WindowBase.h"

static const int TFK_FILE_MASK = 29463274;

static const int TFK_FILE_MAJOR = 1;
static const int TFK_FILE_MINOR = 2;
static const int TFK_FILE_SUBMINOR = 0;

class TFK_BaseSet : public fk_ParserBase {

 private:

	TFK_PointBase		*pointBase;
	TFK_LineBase		*lineBase;
	TFK_PolygonBase		*polyBase;
	TFK_BlockBase		*blockBase;
	TFK_SphereBase		*sphereBase;
	TFK_PrismBase		*prismBase;
	TFK_ConeBase		*coneBase;
	TFK_FileDataBase	*fileBase;
	TFK_MeshBase		*meshBase;
	TFK_TextureBase		*textureBase;
	TFK_LightBase		*lightBase;
	TFK_PaletteBase		*paletteBase;

	TFK_WindowBase		*winBase;

	fk_Model			*camera;
	fk_Scene			*scene;

	bool				planeMode;

	void				VerWrite(FILE *, fk_DataFormatMode);
	int					VerRead(FILE *, fk_DataFormatMode);
	void				BGWrite(FILE *, fk_DataFormatMode);
	fk_Color			BGRead(FILE *, fk_DataFormatMode);

 public:
	TFK_BaseSet(void);
	~TFK_BaseSet();

	TFK_PointBase *		getPointBase(void);
	TFK_LineBase *		getLineBase(void);
	TFK_PolygonBase *	getPolygonBase(void);
	TFK_BlockBase *		getBlockBase(void);
	TFK_SphereBase *	getSphereBase(void);
	TFK_PrismBase *		getPrismBase(void);
	TFK_ConeBase *		getConeBase(void);
	TFK_FileDataBase *	getFileDataBase(void);
	TFK_MeshBase *		getMeshBase(void);
	TFK_TextureBase *	getTextureBase(void);
	TFK_LightBase *		getLightBase(void);
	TFK_PaletteBase *	getPaletteBase(void);
	TFK_WindowBase *	getWindowBase(void);
	fk_Model *			getCamera(void);

	void				setBGColor(double, double, double);

	bool				saveFile(string, fk_DataFormatMode = FK_BINARY_FILE);
	bool				loadFile(string, fk_DataFormatMode = FK_BINARY_FILE);

	void				setPlaneMode(bool);
	bool				getPlaneMode(void);
};	


#endif // !__TINY_FK_BASE_SET_HEADER__
