/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform.xpath;

import java.io.ByteArrayInputStream;
import jp.haw.grain.transform.xpath.GudXPathVisitor;
import jp.haw.grain.xpath.XPathByteCodeElement;
import jp.haw.grain.xpath.XPathByteCodeElementInterface;
import jp.haw.grain.xpath.compiler.ASTXPathExpression;
import jp.haw.grain.xpath.compiler.ParseException;
import jp.haw.grain.xpath.compiler.XPathParser;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathExprCompiler {
    protected XPathParser parser = new XPathParser(new ByteArrayInputStream(new byte[0]));

    public XPathExprCompiler() {
        this.parser.disable_tracing();
    }

    public Node compile(String xpath, Document ownerDoc) throws ParseException {
        this.parser.ReInit(new ByteArrayInputStream(xpath.getBytes()));
        GudXPathVisitor visitor = new GudXPathVisitor(ownerDoc);
        ASTXPathExpression node = this.parser.XPathExpression();
        XPathByteCodeElementInterface byteCodeElement = (XPathByteCodeElementInterface)node.jjtAccept(visitor, null);
        Element exprRoot = ownerDoc.createElementNS("http://grain.jp/xpath/", "xpath:expr");
        exprRoot.appendChild(this.optimizeStack(byteCodeElement, ownerDoc));
        return exprRoot;
    }

    protected DocumentFragment optimizeStack(XPathByteCodeElementInterface element, Document doc) {
        DocumentFragment df = doc.createDocumentFragment();
        this._optimizeStack(element, df);
        return df;
    }

    private void _optimizeStack(XPathByteCodeElementInterface element, DocumentFragment df) {
        if (element.getByteCodeType() == 0) {
            df.appendChild(element.getElement());
            return;
        }
        if (element.getByteCodeType() == 2) {
            Element owner = element.getElement();
            if (element.hasChildNodes()) {
                NodeList closureChildren = element.getChildNodes();
                for (int i = 0; i < closureChildren.getLength(); ++i) {
                    DocumentFragment closureDf = this.optimizeStack((XPathByteCodeElement)closureChildren.item(i), df.getOwnerDocument());
                    owner.appendChild(closureDf);
                }
            }
            df.appendChild(owner);
            return;
        }
        if (element.hasChildNodes()) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this._optimizeStack((XPathByteCodeElementInterface)((Object)children.item(i)), df);
            }
        }
        if (element.getByteCodeType() == 1) {
            df.appendChild(element.getElement());
        }
    }
}

