/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function start
//
(function( window, undefined )
{

/**
 * Config
 */
var Config =
{
	debug			: true,
	loopInterval	: 35,
	canvasId		: "screen",
	usageId			: "usage",
	consoleId		: "console",
	dataJSName		: "stage.js"
};

/**
 * Debug
 */
var Debug = new function()
{
	/**
	 * メッセージボックスを表示する。
	 */
	this.alert = function( message )
	{
		if ( Config.debug )
		{
			window.alert( message );
		}
	};
	/**
	 * デバッグエリアに出力する。
	 */
	this.print = function( message )
	{
		if ( Config.debug )
		{
			var console	= window.document.getElementById( Config.consoleId );
			console.innerHTML += "<p>" + message + "</p>";
		}
	};
}();

/**
 * Command
 */
var Command = function()
{
	this.tbl	= {};
};

(function( pt )
{
	/**
	 * 
	 */
	pt.clear = function()
	{
		for ( var key in this.tbl )
		{
			this.tbl[ key ] = 0;
		}
	};
})( Command.prototype );

/**
 * Element
 */
var Element = function()
{
	this.prev	= null;
	this.next	= null;
	this.child	= null;	// head of child list
};

(function( pt )
{
	/**
	 * 
	 */
	pt.link = function( tmpPrev )
	{
		var tmpNext	= tmpPrev.next;
		tmpPrev.next= this;

		this.prev	= tmpPrev;
		this.next	= tmpNext;

		if ( tmpNext != null )
		{
			tmpNext.prev	= this;
		}
	};
	/**
	 * 
	 */
	pt.unlink = function()
	{
		var tmpPrev	= this.prev;
		var tmpNext	= this.next;
		if ( tmpPrev != null )
		{
			tmpPrev.next	= tmpNext;
		}
		if ( tmpNext != null )
		{
			tmpNext.prev	= tmpPrev;
		}
	};
})( Element.prototype );

/**
 * Task
 */
var Task = function()
{
	this.status		= 0;
	this.command	= null;
};
Task.prototype = new Element();

(function( pt )
{
	/**
	 * 
	 */
	pt.update = function( scene )
	{
		return false;
	};
	/**
	 * 
	 */
	pt.draw = function( scene )
	{
	};
	/**
	 * 
	 */
	pt.updateChildren = function( scene )
	{
		var upd = false;
		for ( var task = this.child; task != null; task = task.next )
		{
			if ( task.update( scene ) )
			{
				upd = true;
			}
		}
		return upd;
	};
	/**
	 * 
	 */
	pt.drawChildren = function( scene )
	{
		for ( var task = this.child; task != null; task = task.next )
		{
			task.draw( scene );
		}
	};
})( Task.prototype );


/**
 * Message
 */
var Message = function( type )
{
	this.type	= type;
	this.data	= {};
};

/**
 * MessageHandler
 */
var MessageHandler = function( type, object, func )
{
	this.type		= type;
	this.object		= object;
	this.func		= func;	// function( scene, message )
};

/**
 * MessageManager
 */
var MessageManager = function()
{
	this.queue		= [];
	this.breakQueue	= [];
	this.handlers	= [];
};

(function( pt )
{
	/**
	 * 
	 */
	pt.addHandler = function( handler )
	{
		var type = handler.type;
		if ( !this.handlers[ type ] )
		{
			this.handlers[ type ]		= {};
			this.handlers[ type ].array	= [];
		}
		this.handlers[ type ].array.push( handler );
	};
	/**
	 * 
	 */
	pt.removeHandler = function( handler )
	{
		var array = this.handlers[ handler.type ].array;
		for ( var i = 0; i < array.length; i++ )
		{
			if ( array[i] == handler )
			{
				array.splice( i, 1 );
				break;
			}
		}
	};
	/**
	 * 
	 */
	pt.getHandlerArray = function( message )
	{
		var type = message.type;
		if ( this.handlers[ type ] )
		{
			return this.handlers[ type ].array;
		}
		return null;
	};

	/**
	 * 
	 */
	pt.postMessage = function( message )
	{
		this.queue.push( message );
	};
	/**
	 * 
	 */
	pt.postBreakMessage = function( message )
	{
		this.breakQueue.push( message );
	};
	/**
	 * 
	 */
	pt.handleMessages = function( scene )
	{
		var tmpQueue	= this.queue.concat( this.breakQueue );
		var ret			= ( this.breakQueue.length <= 0 );
		// clear queue
		this.queue.length		= 0;
		this.breakQueue.length	= 0;

		// for each queue
		for ( var i = 0; i < tmpQueue.length; i++ )
		{
			var message	= tmpQueue[i];
			var array	= this.getHandlerArray( message );
			if ( array )
			{
				// for each handler
				for ( var n = 0; n < array.length; n++ )
				{
					var handler = array[n];
					handler.func.call( handler.object, scene, message );
				}
			}
		}
		return ret;
	};
})( MessageManager.prototype );

/**
 * Scene
 */
var Scene = function( app )
{
	this.app		= null;
	this.name		= null;

	this.canvas		= null;
	this.context	= null;

	this.ticks		= 0;
	this.focus		= null;

	this.msgManager	= null;	// ここで new するとインスタンス間で実体が共有される？
};
Scene.prototype = new Task();

(function( pt )
{
	/**
	 * 
	 */
	pt.setFocus = function( task )
	{
		this.focus	= task;
	};
	/**
	 * 
	 */
	pt.getFocus = function()
	{
		return this.focus;
	};
	/**
	 * 
	 */
	pt.setUsage = function( html )
	{
		var usage	= window.document.getElementById( Config.usageId );
		usage.innerHTML = html;
	};
	/**
	 * 
	 */
	pt.holdCanvas = function()
	{
		this.canvas		= window.document.getElementById( Config.canvasId );
		this.context	= this.canvas.getContext("2d");
	};
	/**
	 * 
	 */
	pt.updateChildren = function( scene )
	{
		var upd = false;
		for ( var task = this.child; task != null; task = task.next )
		{
			// check focus
			if ( this.focus == null || this.focus == task )
			{
				if ( task.update( scene ) ) { upd = true; }
			}
		}
		return upd;
	};
	/**
	 * 
	 */
	pt.update = function( scene )
	{
		this.ticks++;

		// update & draw
		var upd = this.updateChildren( scene );
		var msg = ( this.msgManager ) ? this.msgManager.handleMessages( this ) : true;
		if ( upd && msg )
		{
			this.drawChildren( scene );
		}
	};
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		this.command.handleSysEvent( event );
	};
})( Scene.prototype );

/**
 * SceneManager
 */
var SceneManager = function()
{
	this.current	= null;

	this.stack		= [];
	this.scenes		= {};
};

(function( pt )
{
	/**
	 * 
	 */
	pt.add = function( scene )
	{
		this.scenes[ scene.name ] = scene;
	};
	/**
	 * 
	 */
	pt.push = function( name )
	{
		var scene = this.scenes[ name ];
		if ( scene )
		{
			this.stack.push( scene );
			this.current = scene;
			return this.current;
		}
		else
		{
			return null;
		}
	};
	/**
	 * 
	 */
	pt.pop = function()
	{
		if ( this.stack.length > 1 )
		{
			this.stack.pop();
			this.current = this.stack[ this.stack.length - 1 ];
			return this.current;
		}
		else
		{
			return null;
		}
	};
	/**
	 * 
	 */
	pt.update = function()
	{
		this.current.update( this.current );
	};
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		this.current.handleSysEvent( event );
	};
})( SceneManager.prototype );


/**
 * AppStatus
 */
var AppStatus =
{
	READY	: 0,
	RUNNING	: 1,
	ERROR	: 2
};

/**
 * Application
 */
var Application = function()
{
	this.status		= AppStatus.READY;
	this.timerId	= 0;

	this.sceneManager	= new SceneManager();
};

(function( pt )
{
	/**
	 * 
	 */
	pt.loop = function()
	{
		try
		{
			this.sceneManager.update();
		}
		catch ( e )
		{
			this.kill();
			Debug.alert( e );
		}
	};
	/**
	 * 
	 */
	pt.kill = function()
	{
		this.status	= AppStatus.ERROR;
		window.clearInterval( this.timerId );
	};
	/**
	 * 
	 */
	pt.loadScript = function( url )
	{
		var node	= window.document.createElement("script");
		node.type	= "text/javascript";
		//node.language	= "javascript";
		node.charset= "UTF-8";
		node.src	= url;

		window.document.getElementsByTagName("body")[0].appendChild( node );
	};
	/**
	 * 
	 */
	pt.start = function()
	{
		var self = this;

		window.onload	= function()
		{
			// check status
			if ( self.status == AppStatus.ERROR ) { return; }

			var canvas	= window.document.getElementById( Config.canvasId );

			// set handler
			window.document.onkeydown	= function( e ) { self.sceneManager.handleSysEvent( e ); };
			window.document.onkeyup		= function( e ) { self.sceneManager.handleSysEvent( e ); };
			canvas.onmousedown			= function( e ) { self.sceneManager.handleSysEvent( e ); };
			canvas.onmouseup			= function( e ) { self.sceneManager.handleSysEvent( e ); };
			canvas.onmousemove			= function( e ) { self.sceneManager.handleSysEvent( e ); };
			canvas.onmouseout			= function( e ) { self.sceneManager.handleSysEvent( e ); };

			try
			{
				self.sceneManager.current.show();
				self.timerId = window.setInterval( function() { self.loop(); }, Config.loopInterval );
				self.status	= AppStatus.RUNNING;
			}
			catch ( e )
			{
				Debug.alert( e );
			}
		};
	};
})( Application.prototype );


// Expose
if ( !window.h5glib ) { window.h5glib = {}; }

window.h5glib.Config		= Config;
window.h5glib.Debug			= Debug;
window.h5glib.Command		= Command;
window.h5glib.Task			= Task;
window.h5glib.Message		= Message;
window.h5glib.MessageHandler= MessageHandler;
window.h5glib.MessageManager= MessageManager;
window.h5glib.Scene			= Scene;
window.h5glib.Application	= Application;


// Anonymous function end
//
})( window );
