/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager2;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.TalkView;
import jp.sourceforge.jindolf.TopicFilter;
import jp.sourceforge.jindolf.TopicView;

public class FilterPanel
extends JFrame
implements ItemListener,
TopicFilter {
    private JCheckBox checkPublic = new JCheckBox("\u516c\u958b", true);
    private JCheckBox checkWolf = new JCheckBox("\u72fc", true);
    private JCheckBox checkPrivate = new JCheckBox("\u72ec\u308a\u8a00", true);
    private JCheckBox checkGrave = new JCheckBox("\u5893\u4e0b", true);
    private Map<Avatar, JCheckBox> cbMap = new HashMap<Avatar, JCheckBox>();
    private EventListenerList listeners;

    public FilterPanel() {
        super("\u767a\u8a00\u30d5\u30a3\u30eb\u30bf - " + Jindolf.title);
        this.setResizable(true);
        Toolkit kit = this.getToolkit();
        kit.setDynamicLayout(false);
        this.setIconImage(GUIUtils.getWindowIconImage());
        this.setLocationByPlatform(true);
        JPanel avatarPanel = new JPanel();
        LayoutManager2 layout = new GridBagLayout();
        GridBagConstraints cst = new GridBagConstraints();
        cst.weightx = 0.25;
        cst.anchor = 17;
        avatarPanel.setLayout(layout);
        int ct = 0;
        for (Avatar avatar : Avatar.getPredefinedAvatars()) {
            JCheckBox checkBox = new JCheckBox(avatar.getName(), true);
            if (ct >= 3) {
                cst.gridwidth = 0;
                ct = 0;
            } else {
                cst.gridwidth = 1;
                ++ct;
            }
            avatarPanel.add((Component)checkBox, cst);
            checkBox.addItemListener(this);
            this.cbMap.put(avatar, checkBox);
        }
        JScrollPane avatarsc = new JScrollPane(avatarPanel);
        avatarsc.setHorizontalScrollBarPolicy(31);
        JPanel topicPanel = new JPanel();
        layout = new BoxLayout(topicPanel, 1);
        topicPanel.setLayout(layout);
        topicPanel.add(this.checkPublic);
        topicPanel.add(this.checkWolf);
        topicPanel.add(this.checkPrivate);
        topicPanel.add(this.checkGrave);
        this.checkPublic.addItemListener(this);
        this.checkWolf.addItemListener(this);
        this.checkPrivate.addItemListener(this);
        this.checkGrave.addItemListener(this);
        Container content = this.getContentPane();
        layout = new BoxLayout(content, 0);
        content.setLayout(layout);
        content.add(topicPanel);
        content.add(avatarsc);
        this.listeners = new EventListenerList();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listeners.getListeners(ChangeListener.class);
    }

    protected void fireCheckChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener listener : this.getChangeListeners()) {
            listener.stateChanged(changeEvent);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        this.fireCheckChanged();
    }

    public boolean isFiltered(TopicView topicView) {
        JCheckBox cbox;
        if (!(topicView instanceof TalkView)) {
            return false;
        }
        TalkView talkView = (TalkView)topicView;
        Talk.Type type = talkView.getTalkType();
        switch (type) {
            case PUBLIC: {
                cbox = this.checkPublic;
                break;
            }
            case WOLFONLY: {
                cbox = this.checkWolf;
                break;
            }
            case PRIVATE: {
                cbox = this.checkPrivate;
                break;
            }
            case GRAVE: {
                cbox = this.checkGrave;
                break;
            }
            default: {
                assert (false);
                return true;
            }
        }
        if (!cbox.isSelected()) {
            return true;
        }
        Avatar avatar = talkView.getAvatar();
        cbox = this.cbMap.get(avatar);
        return !cbox.isSelected();
    }

    public TopicFilter.FilterContext getFilterContext() {
        return new FilterPanelContext();
    }

    public boolean isSame(TopicFilter.FilterContext context) {
        if (context == null) {
            return false;
        }
        if (!(context instanceof FilterPanelContext)) {
            return false;
        }
        FilterPanelContext argContext = (FilterPanelContext)context;
        FilterPanelContext thisContext = (FilterPanelContext)this.getFilterContext();
        return thisContext.context.equals(argContext.context);
    }

    private class FilterPanelContext
    implements TopicFilter.FilterContext {
        private final BitSet context = new BitSet();

        public FilterPanelContext() {
            int index = 0;
            this.context.set(index++, FilterPanel.this.checkPublic.isSelected());
            this.context.set(index++, FilterPanel.this.checkWolf.isSelected());
            this.context.set(index++, FilterPanel.this.checkPrivate.isSelected());
            this.context.set(index++, FilterPanel.this.checkGrave.isSelected());
            for (Avatar avatar : Avatar.getPredefinedAvatars()) {
                JCheckBox checkBox = (JCheckBox)FilterPanel.this.cbMap.get(avatar);
                this.context.set(index++, checkBox.isSelected());
            }
        }
    }
}

