/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import javax.swing.text.View;
import jp.sourceforge.jindolf.AnchorListener;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.JdfEditorKit;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.TopicFilter;
import jp.sourceforge.jindolf.TopicView;
import jp.sourceforge.jindolf.Village;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdfBrowser
extends JEditorPane {
    private static final Highlighter.HighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(0xD02020));
    private Village village;
    private Period period;
    private TopicFilter.FilterContext filterContext;
    private boolean hasShown = false;

    public JdfBrowser(Period period) {
        this.setEditable(false);
        this.setContentType("text/html");
        this.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        this.setPeriod(period);
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        HyperlinkListener[] listeners;
        if (period == this.period) {
            return;
        }
        this.period = period;
        this.hasShown = false;
        this.filterContext = null;
        this.setText("");
        if (this.period == null) {
            return;
        }
        if (period.getVillage() == this.village) {
            return;
        }
        this.village = period.getVillage();
        JdfEditorKit kit = new JdfEditorKit(this.village);
        this.setEditorKit(kit);
        for (HyperlinkListener listener : listeners = this.getHyperlinkListeners()) {
            this.removeHyperlinkListener(listener);
        }
        this.addHyperlinkListener(new AnchorListener(this.village));
    }

    public void showTopics(TopicFilter filter, boolean force) {
        if (force || !this.hasShown) {
            CharSequence html = this.period.buildJdfHTML();
            this.setCharSequence(html);
            this.hasShown = true;
            this.filterContext = null;
        }
        this.filtering(filter);
    }

    public void filtering(TopicFilter filter) {
        if (filter.isSame(this.filterContext)) {
            return;
        }
        List<TopicView> viewList = this.getTopicViewList(null, null);
        for (TopicView view : viewList) {
            if (filter.isFiltered(view)) {
                view.setVisible(false);
            } else {
                view.setVisible(true);
            }
            View parentView = view.getParent();
            if (parentView == null) continue;
            parentView.preferenceChanged(view, true, true);
        }
        this.filterContext = filter.getFilterContext();
    }

    private void setCharSequence(CharSequence html) {
        Document doc;
        block4: {
            StringReader reader = html != null ? new StringReader(((Object)html).toString()) : new StringReader("");
            EditorKit kit = this.getEditorKit();
            doc = kit.createDefaultDocument();
            try {
                kit.read(reader, doc, 0);
            }
            catch (IOException e) {
                assert (false);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        this.setDocument(doc);
    }

    public void highlightRegex(Pattern pattern) {
        int endPos;
        int startPos;
        String text;
        Highlighter.Highlight[] highlights;
        if (pattern == null) {
            return;
        }
        Highlighter highlighter = this.getHighlighter();
        for (Highlighter.Highlight highlight : highlights = highlighter.getHighlights()) {
            if (highlight.getPainter() != highlightPainter) continue;
            highlighter.removeHighlight(highlight);
        }
        Document doc = this.getDocument();
        int docLength = doc.getLength();
        try {
            text = doc.getText(0, docLength);
        }
        catch (BadLocationException e) {
            assert (false);
            return;
        }
        Matcher matcher = pattern.matcher(text);
        matcher.region(0, docLength);
        while (matcher.find() && (startPos = matcher.start()) != (endPos = matcher.end())) {
            matcher.region(endPos, docLength);
            try {
                highlighter.addHighlight(startPos, endPos, highlightPainter);
            }
            catch (BadLocationException e) {
                assert (false);
                return;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(GUIUtils.getDefaultHints());
        super.paint(g);
    }

    public View getRootView() {
        TextUI textUI = this.getUI();
        View root = textUI.getRootView(this);
        return root;
    }

    public List<TopicView> getTopicViewList(View parent, List<TopicView> list) {
        if (parent == null) {
            parent = this.getRootView();
            list = new LinkedList<TopicView>();
        }
        int childNo = parent.getViewCount();
        for (int ct = 0; ct <= childNo - 1; ++ct) {
            View child = parent.getView(ct);
            if (child instanceof TopicView) {
                list.add((TopicView)child);
                continue;
            }
            this.getTopicViewList(child, list);
        }
        return list;
    }
}

