/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import javax.swing.text.StyleContext;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.StyleSheet;
import jp.sourceforge.jindolf.JdfViewFactory;
import jp.sourceforge.jindolf.UnshareStyleEditorKit;
import jp.sourceforge.jindolf.Village;

public class JdfEditorKit
extends UnshareStyleEditorKit {
    private static final String cssSrc = "resources/jindolf.css";
    private static final String cssContent;
    private ViewFactory defaultFactory;

    public JdfEditorKit(Village village) {
        this.defaultFactory = new JdfViewFactory(village);
        StyleSheet originalStyle = new StyleSheet();
        StringReader reader = new StringReader(cssContent);
        try {
            originalStyle.loadRules(reader, null);
            ((Reader)reader).close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.setStyleSheet(originalStyle);
    }

    public ViewFactory getViewFactory() {
        return this.defaultFactory;
    }

    public void dumpStyleSheet(PrintStream out) {
        StyleSheet sheet = this.getStyleSheet();
        Enumeration<?> styleNames = sheet.getStyleNames();
        while (styleNames.hasMoreElements()) {
            String stylename = (String)styleNames.nextElement();
            out.println("stylename=" + stylename);
            StyleContext.NamedStyle style = (StyleContext.NamedStyle)sheet.getStyle(stylename);
            String styleName = style.getName();
            out.println("rulename=" + styleName);
            Enumeration<?> attrs = style.getAttributeNames();
            while (attrs.hasMoreElements()) {
                Object key = attrs.nextElement();
                Object value = style.getAttribute(key);
                out.println("key=" + key + "   value=" + value);
            }
        }
    }

    static {
        Class<JdfEditorKit> klass = JdfEditorKit.class;
        InputStream is = klass.getResourceAsStream(cssSrc);
        Reader reader = new InputStreamReader(is);
        reader = new BufferedReader(reader);
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[256];
        try {
            int chs;
            while ((chs = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, chs);
            }
        }
        catch (IOException e) {
            sb.delete(0, sb.length());
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        cssContent = sb.toString();
    }
}

