/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Image;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import jp.sourceforge.jindolf.AnchorView;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.AvatarView;
import jp.sourceforge.jindolf.BaloonView;
import jp.sourceforge.jindolf.SysEventView;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.TalkView;
import jp.sourceforge.jindolf.Village;

public class JdfViewFactory
extends HTMLEditorKit.HTMLFactory {
    private Village village;

    public JdfViewFactory(Village village) {
        this.village = village;
    }

    public View create(Element elem) {
        AttributeSet attr = elem.getAttributes();
        AttributeSet attrAnchor = (AttributeSet)attr.getAttribute(HTML.Tag.A);
        if (attrAnchor != null) {
            String href = (String)attrAnchor.getAttribute(HTML.Attribute.HREF);
            if (href == null) {
                return super.create(elem);
            }
            return new AnchorView(elem);
        }
        Object obj = attr.getAttribute(StyleConstants.NameAttribute);
        if (obj instanceof HTML.Tag) {
            HTML.Tag kind = (HTML.Tag)obj;
            if (kind == HTML.Tag.IMG) {
                Image image;
                Object objClass = attr.getAttribute("avatar");
                String fullName = (String)objClass;
                if (fullName == null) {
                    return super.create(elem);
                }
                if (fullName.equals("")) {
                    image = this.village.getGraveImage();
                } else {
                    Avatar avatar = this.village.getAvatar(fullName);
                    image = this.village.getAvatarFaceImage(avatar);
                }
                return new AvatarView(elem, image);
            }
            if (kind == HTML.Tag.DIV) {
                Object objClass = attr.getAttribute(HTML.Attribute.CLASS);
                String attrClass = (String)objClass;
                if (attrClass == null) {
                    return super.create(elem);
                }
                if (attrClass.equals("topic")) {
                    SysEventView view = new SysEventView(elem, null);
                    return view;
                }
                if (attrClass.equals("message")) {
                    String fullName = (String)attr.getAttribute("avatar");
                    Avatar avatar = this.village.getAvatar(fullName);
                    String talkType = (String)attr.getAttribute("talktype");
                    Talk.Type type = Talk.decodeIntlType(talkType);
                    TalkView view = new TalkView(elem, avatar, type);
                    return view;
                }
                if (attrClass.equals("public")) {
                    BaloonView view = new BaloonView(elem, Talk.Type.PUBLIC);
                    return view;
                }
                if (attrClass.equals("grave")) {
                    BaloonView view = new BaloonView(elem, Talk.Type.GRAVE);
                    return view;
                }
                if (attrClass.equals("wolfonly")) {
                    BaloonView view = new BaloonView(elem, Talk.Type.WOLFONLY);
                    return view;
                }
                if (attrClass.equals("private")) {
                    BaloonView view = new BaloonView(elem, Talk.Type.PRIVATE);
                    return view;
                }
            }
        }
        return super.create(elem);
    }
}

