/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jp.sourceforge.jindolf.Controller;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.MenuManager;
import jp.sourceforge.jindolf.TopFrameView;

public class Jindolf {
    public static final String version = "2.1.8";
    public static final String license = "The MIT License";
    public static final String contact = "http://jindolf.sourceforge.jp/";
    public static final Date initDate;
    public static final long initNano;
    public static final ClassLoader loader;
    public static final Class selfClass;
    public static final Package selfPackage;
    public static final Package jrePackage;
    public static final Runtime runtime;
    public static SecurityManager secManager;
    public static final String title;
    public static final String author;
    public static final String copyright;
    private static Dimension initGeometry;

    private static void preLoadClass() throws LinkageError, ExceptionInInitializerError {
        String[] classes;
        for (String className : classes = new String[]{"java.lang.Object", "jp.sourceforge.jindolf.JdfEditorKit", "jp.sourceforge.jindolf.TabBrowser", "jp.sourceforge.jindolf.TopFrameView", "java.net.HttpURLConnection", "java.text.SimpleDateFormat", "javax.swing.JEditorPane", "javax.swing.text.html.CSS", "javax.swing.text.html.StyleSheet", "javax.swing.text.html.HTMLDocument", "javax.swing.text.html.BlockView", "javax.swing.text.html.ParagraphView", "javax.swing.text.html.InlineView", "javax.swing.text.html.parser.DocumentParser"}) {
            try {
                if (loader != null) {
                    Class.forName(className, true, loader);
                    continue;
                }
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Jindolf.warnMessage(e);
            }
        }
    }

    public static boolean hasRuntime5() {
        boolean result;
        try {
            result = jrePackage.isCompatibleWith("1.5");
        }
        catch (NumberFormatException e) {
            return false;
        }
        return result;
    }

    public static boolean hasRuntime6() {
        boolean result;
        try {
            result = jrePackage.isCompatibleWith("1.6");
        }
        catch (NumberFormatException e) {
            return false;
        }
        return result;
    }

    static void exit(int exitCode) throws SecurityException {
        System.out.flush();
        System.err.flush();
        runtime.runFinalization();
        runtime.gc();
        Thread.yield();
        try {
            runtime.exit(exitCode);
        }
        catch (SecurityException e) {
            Jindolf.warnMessage(e);
            throw e;
        }
    }

    private static void testEnvironment() {
        if (!Jindolf.hasRuntime5()) {
            Jindolf.errorMessage(title + " need J2SE5 platform or later.");
            Jindolf.exit(1);
        }
        if (GraphicsEnvironment.isHeadless()) {
            Jindolf.errorMessage(title + " need bit-map display, keyboard, & pointing-device.");
            Jindolf.exit(1);
        }
    }

    public static void main(final String[] args) {
        Jindolf.testEnvironment();
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Jindolf.startGUI(args);
            }
        });
        Thread.yield();
    }

    private static void startGUI(String[] args) {
        Window splashWindow;
        if (!Jindolf.hasRuntime6()) {
            splashWindow = Jindolf.createSplashWindow();
            splashWindow.setVisible(true);
            Thread.yield();
        } else {
            splashWindow = null;
        }
        Jindolf.preLoadClass();
        LandsModel model = new LandsModel();
        model.loadLandList();
        TopFrameView topFrame = Jindolf.buildMVC(model);
        topFrame.setDefaultCloseOperation(3);
        topFrame.setResizable(true);
        topFrame.setIconImage(GUIUtils.getWindowIconImage());
        topFrame.pack();
        topFrame.setSize(initGeometry);
        topFrame.setLocationByPlatform(true);
        Toolkit kit = topFrame.getToolkit();
        kit.setDynamicLayout(false);
        if (splashWindow != null) {
            splashWindow.setVisible(false);
            splashWindow.dispose();
            splashWindow = null;
        }
        topFrame.setVisible(true);
        Thread.yield();
    }

    private static Window createSplashWindow() {
        JWindow splashWindow = new JWindow();
        JLabel splashLabel = new JLabel(GUIUtils.getLogoIcon());
        splashWindow.add(splashLabel);
        splashWindow.pack();
        splashWindow.setLocationRelativeTo(null);
        return splashWindow;
    }

    private static TopFrameView buildMVC(LandsModel model) {
        MenuManager menuManager = new MenuManager();
        TopFrameView topFrame = new TopFrameView();
        topFrame.setJMenuBar(menuManager.createMenuBar());
        new Controller(menuManager, topFrame, model);
        return topFrame;
    }

    private static void warnMessage(Object message) {
        System.out.println(message);
    }

    private static void errorMessage(Object message) {
        System.err.println(message);
    }

    private Jindolf() {
    }

    static {
        ClassLoader thisLoader;
        initGeometry = new Dimension(800, 600);
        initDate = new Date();
        initNano = System.nanoTime();
        selfClass = Jindolf.class;
        selfPackage = selfClass.getPackage();
        jrePackage = Object.class.getPackage();
        try {
            thisLoader = selfClass.getClassLoader();
        }
        catch (SecurityException e) {
            thisLoader = null;
        }
        loader = thisLoader;
        runtime = Runtime.getRuntime();
        secManager = System.getSecurityManager();
        String implTitle = selfPackage.getImplementationTitle();
        title = implTitle != null ? implTitle : "Jindolf";
        String implVersion = selfPackage.getImplementationVersion();
        if (implVersion != null && !version.equals(implVersion)) {
            throw new ExceptionInInitializerError("unmatch package version");
        }
        String implVendor = selfPackage.getImplementationVendor();
        author = implVendor != null ? implVendor : "olyutorskii";
        copyright = "Copyright(c) 2008 " + author;
    }
}

