/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import jp.sourceforge.jindolf.JdfBrowser;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.TabBrowser;
import jp.sourceforge.jindolf.Village;

public class TopFrameView
extends JFrame {
    private final JSplitPane split;
    private final JTree landSelectView;
    private final JTextArea landInfo;
    private final JScrollPane llss;
    private final JTextField statusBar;
    private final JProgressBar progressBar;
    private final JButton reloadButton;
    private final TabBrowser tabBrowser;
    private final JPanel browsePanel;
    private final JComboBox findBox;
    private final JButton searchButton;

    public TopFrameView() {
        this.setFrameTitle(null);
        this.landSelectView = new JTree();
        this.landSelectView.setRootVisible(false);
        AbstractBorder border = new EmptyBorder(5, 5, 5, 5);
        this.landSelectView.setBorder(border);
        JScrollPane scrollVList = new JScrollPane(this.landSelectView);
        JLabel label = new JLabel("\u6751\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044");
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        this.split = new JSplitPane();
        this.split.setLeftComponent(scrollVList);
        this.split.setRightComponent(label);
        this.split.setOrientation(1);
        this.split.setContinuousLayout(false);
        this.split.setOneTouchExpandable(true);
        this.split.setDividerLocation(200);
        this.statusBar = new JTextField();
        this.statusBar.setText(Jindolf.title + " \u3092\u4f7f\u3063\u3066\u304f\u308c\u3066\u3042\u308a\u304c\u3068\u3046 !");
        this.statusBar.setEditable(false);
        border = new BevelBorder(1);
        border = new CompoundBorder(border, new EmptyBorder(2, 5, 2, 2));
        this.statusBar.setBorder(border);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(false);
        this.progressBar.setOrientation(1);
        Container content = this.getContentPane();
        BorderLayout layout = new BorderLayout();
        content.setLayout(layout);
        content.add((Component)this.split, "Center");
        content.add((Component)this.statusBar, "South");
        content.add((Component)this.progressBar, "East");
        this.landInfo = new JTextArea();
        this.llss = new JScrollPane(this.landInfo);
        border = new EmptyBorder(5, 5, 5, 5);
        this.landInfo.setBorder(border);
        this.reloadButton = new JButton("Reload");
        this.reloadButton.setActionCommand("RELOAD");
        this.findBox = new JComboBox();
        this.findBox.setEditable(true);
        this.findBox.addItem("");
        this.findBox.addItem("\u3010[^\u3011]*\u3011");
        this.findBox.addItem("[\u25a0\u25cf\u25bc]");
        this.searchButton = new JButton("Search");
        this.searchButton.setActionCommand("SEARCH");
        JComponent buttons = this.designButtons();
        this.tabBrowser = new TabBrowser();
        this.browsePanel = new JPanel();
        layout = new BorderLayout();
        this.browsePanel.setLayout(layout);
        this.browsePanel.add((Component)buttons, "North");
        this.browsePanel.add((Component)this.tabBrowser, "Center");
    }

    private JComponent designButtons() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints cst = new GridBagConstraints();
        panel.setLayout(layout);
        cst.insets = new Insets(1, 1, 1, 1);
        cst.fill = 0;
        cst.anchor = 17;
        panel.add((Component)this.reloadButton, cst);
        cst.anchor = 13;
        cst.weightx = 1.0;
        panel.add((Component)this.findBox, cst);
        cst.weightx = 0.0;
        panel.add((Component)this.searchButton, cst);
        return panel;
    }

    public JTree getLandTree() {
        return this.landSelectView;
    }

    public TabBrowser getTabBrowser() {
        return this.tabBrowser;
    }

    public JButton getReloadButton() {
        return this.reloadButton;
    }

    public JComboBox getFindBox() {
        return this.findBox;
    }

    public JButton getSearchButton() {
        return this.searchButton;
    }

    public JdfBrowser currentJdfBrowser() {
        JdfBrowser result = this.tabBrowser.currentJdfBrowser();
        return result;
    }

    public Village currentVillage() {
        return this.tabBrowser.getVillage();
    }

    public void setFrameTitle(String villageName) {
        String title = Jindolf.title;
        if (villageName != null && villageName.length() > 0) {
            title = villageName + " - " + title;
        }
        this.setTitle(title);
    }

    public void setBusy(String message, boolean busy) {
        this.updateStatusBar(message);
        if (busy) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.progressBar.setIndeterminate(true);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
            this.progressBar.setIndeterminate(false);
        }
    }

    protected void updateStatusBar(String message) {
        if (message == null) {
            return;
        }
        if (message.length() <= 0) {
            message = " ";
        }
        this.statusBar.setText(message);
    }

    public void showVillageInfo(Village village) {
        this.setFrameTitle(village.getVillageName());
        this.tabBrowser.setVillage(village);
        int loc = this.split.getDividerLocation();
        this.split.setRightComponent(this.browsePanel);
        this.split.setDividerLocation(loc);
    }

    public void showLandInfo(Land land) {
        this.setFrameTitle(land.getLandName());
        StringBuilder info = new StringBuilder();
        info.append("\u56fd\u540d :\t").append(land.getLandName()).append('\n');
        info.append("\u8b58\u5225\u540d :\t").append(land.getLandIdentifier()).append('\n');
        info.append("\u30d9\u30fc\u30b9URL :\t").append(land.getServerAccess().getBaseURL()).append('\n');
        DateFormat dform = DateFormat.getDateTimeInstance(0, 0);
        Date start = land.getStartDate();
        Date end = land.getEndDate();
        info.append("\u5efa\u56fd :\t").append(dform.format(start)).append('\n');
        info.append("\u4ea1\u56fd :\t").append(dform.format(end)).append('\n');
        info.append("\u72b6\u614b :\t");
        switch (land.getType()) {
            case CLOSED: {
                info.append("\u30b5\u30fc\u30d3\u30b9\u7d42\u4e86");
                break;
            }
            case HISTORICAL: {
                info.append("\u904e\u53bb\u30ed\u30b0\u63d0\u4f9b\u306e\u307f");
                break;
            }
            case ACTIVE: {
                info.append("\u7a3c\u52d5\u4e2d");
                break;
            }
        }
        info.append('\n');
        info.append("\u30ed\u30b1\u30fc\u30eb :\t").append(land.getLocale()).append('\n');
        info.append("\u6642\u9593\u5e2f :\t").append(land.getTimeZone().getDisplayName()).append('\n');
        info.append("\u9023\u7d61\u5148 :\t").append(land.getContactInfo()).append('\n');
        info.append("\u8aac\u660e :\t").append(land.getDescription()).append('\n');
        this.landInfo.setText(info.toString());
        int loc = this.split.getDividerLocation();
        this.split.setRightComponent(this.llss);
        this.split.setDividerLocation(loc);
    }
}

