/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.html.BlockView;

public class TopicView
extends BlockView {
    private boolean isVisible = true;

    public TopicView(Element elem) {
        super(elem, 1);
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public float getMaximumSpan(int axis) {
        if (this.isVisible()) {
            return super.getMaximumSpan(axis);
        }
        return 0.0f;
    }

    public float getPreferredSpan(int axis) {
        if (this.isVisible()) {
            return super.getPreferredSpan(axis);
        }
        return 0.0f;
    }

    public float getMinimumSpan(int axis) {
        if (this.isVisible()) {
            return super.getMinimumSpan(axis);
        }
        return 0.0f;
    }

    protected void drawContent(Graphics2D g2, Rectangle bounds) {
        int ix = bounds.x + this.getLeftInset();
        int iy = bounds.y + this.getTopInset();
        Rectangle clip = g2.getClipBounds();
        Rectangle allocChild = new Rectangle();
        int viewMax = this.getViewCount();
        for (int viewNo = 0; viewNo < viewMax; ++viewNo) {
            allocChild.setBounds(ix + this.getOffset(0, viewNo), iy + this.getOffset(1, viewNo), this.getSpan(0, viewNo), this.getSpan(1, viewNo));
            if (!allocChild.intersects(clip)) continue;
            this.paintChild(g2, allocChild, viewNo);
        }
    }

    public void paint(Graphics g, Shape allocation) {
        if (this.isVisible()) {
            super.paint(g, allocation);
        }
    }
}

