/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 17:30:14
 */
package org.asyrinx.brownie.core.chars;

/**
 * @author takeshi
 */
public interface Characters {

    String getName();

    boolean contains(char c);

    String expandToString();

    Characters ALL = new Characters() {
        public String getName() {
            return "all";
        }

        public boolean contains(char c) {
            return true;
        }

        public String expandToString() {
            throw new UnsupportedOperationException();
        }
    };

    Characters NOTHING = new Characters() {
        public String getName() {
            return "nothing";
        }

        public boolean contains(char c) {
            return false;
        }

        public String expandToString() {
            return null;
        }
    };

}