/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/09 16:26:29
 */
package org.asyrinx.brownie.core.chars;

import org.asyrinx.brownie.core.chars.impl.CharRangeCharacters;
import org.asyrinx.brownie.core.chars.impl.CompositeCharacters;

/**
 * @author takeshi
 */
public class English {

    public static final Characters NUMERIC = new CharRangeCharacters("numeric", '0', '9');

    public static final Characters ALPHABET_UPPERCASE = new CharRangeCharacters(
            "upper-case alphabet", 'A', 'Z');

    public static final Characters ALPHABET_LOWERCASE = new CharRangeCharacters(
            "lower-case alphabet", 'a', 'z');

    public static final Characters ALPHABET = new CompositeCharacters("alphabet",
            new Characters[] { ALPHABET_UPPERCASE, ALPHABET_LOWERCASE });

}