/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 18:31:13
 */
package org.asyrinx.brownie.core.chars;

import org.asyrinx.brownie.core.chars.impl.CharRangeCharacters;
import org.asyrinx.brownie.core.chars.impl.CompositeCharacters;
import org.asyrinx.brownie.core.chars.impl.StringCharacters;

/**
 * @author takeshi
 */
public class Japanese {

    /*
     * p
     */

    public static final Characters HANKAKU_NUMERIC = new CharRangeCharacters("p", '0', '9');

    public static final Characters HANKAKU_ALPHABET_UPPERCASE = new CharRangeCharacters(
            "pAt@xbg啶", 'A', 'Z');

    public static final Characters HANKAKU_ALPHABET_LOWERCASE = new CharRangeCharacters(
            "pAt@xbg", 'a', 'z');

    public static final Characters HANKAKU_ALPHABET = new CompositeCharacters("pAt@xbg",
            new Characters[] { HANKAKU_ALPHABET_UPPERCASE, HANKAKU_ALPHABET_LOWERCASE });

    /**
     * 
     */
    public static final Characters HANKAKU_KATAKANA = new CharRangeCharacters("pJ^Ji", '',
            '');

    /*
     * Sp
     */

    public static final Characters ZENKAKU_NUMERIC = new CharRangeCharacters("Sp", 'O', 'X');

    public static final Characters ZENKAKU_ALPHABET_UPPERCASE = new CharRangeCharacters(
            "SpAt@xbg啶", '`', 'y');

    public static final Characters ZENKAKU_ALPHABET_LOWERCASE = new CharRangeCharacters(
            "SpAt@xbg", '', '');

    public static final Characters ZENKAKU_ALPHABET = new CompositeCharacters("SpAt@xbg",
            new Characters[] { ZENKAKU_ALPHABET_UPPERCASE, ZENKAKU_ALPHABET_LOWERCASE });

    /**
     * J^JiAЂ炪ȋʂ̕Q
     */
    public static final Characters KANA_COMMON = new StringCharacters("SpJ^JiESpЂ炪ȋ",
            "JKTU[RS");

    /**
     * ȑSpЂ炪ȁB'['Ȃǂ̃J^JiAЂ炪ȋʂ̕͏ȂĂ܂B
     */
    public static final Characters STRICT_ZENKAKU_HIRAGANA = new CharRangeCharacters("SpЂ炪",
            '', '');

    /**
     * ȑSpJ^JiB'['Ȃǂ̃J^JiAЂ炪ȋʂ̕͏ȂĂ܂B
     * @ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~
     */
    public static final Characters STRICT_ZENKAKU_KATAKANA = new CharRangeCharacters("SpJ^Ji",
            '@', '');

    /**
     * SpЂ炪ȁB'['Ȃǂ̃J^JiAЂ炪ȋʂ̕܂݂܂B
     * ÂĂłƂǂȂɂʂ˂̂͂΂ςЂт҂ӂԂՂւׂ؂قڂۂ܂݂ނ߂
     */
    public static final Characters ZENKAKU_HIRAGANA = new CompositeCharacters("SpЂ炪",
            new Characters[] { STRICT_ZENKAKU_HIRAGANA, KANA_COMMON });

    /**
     * SpJ^JiB'['Ȃǂ̃J^JiAЂ炪ȋʂ̕܂݂܂B
     */
    public static final Characters ZENKAKU_KATAKANA = new CompositeCharacters("SpJ^Ji",
            new Characters[] { STRICT_ZENKAKU_KATAKANA, KANA_COMMON });

    /*
     *  
     */

}