/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/09 16:42:10
 */
package org.asyrinx.brownie.core.chars.dic;

import ognl.Ognl;
import ognl.OgnlException;

import org.asyrinx.brownie.core.chars.Characters;
import org.asyrinx.brownie.core.chars.CharactersDictionary;
import org.asyrinx.brownie.core.resource.MessageResource;
import org.asyrinx.brownie.core.resource.impl.ResourceBundleMessageResource;

/**
 * @author takeshi
 */
public class MsgResourceCharacterSetDictionary implements CharactersDictionary {

    /**
     *  
     */
    public MsgResourceCharacterSetDictionary(MessageResource resource) {
        super();
        this.resource = resource;
    }

    private final MessageResource resource;

    public Characters get(String key) {
        final String objPath = resource.getMessage(key);
        try {
            final Object result = Ognl.getValue(objPath, null);
            if (result instanceof Characters)
                return (Characters) result;
            throw new CharactersDictionaryRuntimeException(objPath + " isn't a instance of "
                    + Characters.class.getName());
        } catch (OgnlException e) {
            throw new CharactersDictionaryRuntimeException(objPath
                    + " isn't valid ognl expression, or no object found", e);
        }
    }

    public static MsgResourceCharacterSetDictionary getDefaultDictionary() {
        return new MsgResourceCharacterSetDictionary(new ResourceBundleMessageResource(
                "org.asyrinx.brownie.core.chars.characters"));
    }

}