/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/15
 */
package org.asyrinx.brownie.core.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.asyrinx.brownie.core.collection.wrapper.MapWrapper;

/**
 * MapC^tF[XɊւ郆[eBeBłB <br>
 * 
 * @see java.util.Map
 * @author akima
 */
public class MapUtils extends org.apache.commons.collections.MapUtils {

	/**
	 * Ɏw肳ꂽ}bvIntegerKeyMap̃C^tF[Xǉ܂B
	 * 
	 * @param map
	 *            ΏۂƂȂMapIuWFNg
	 * @return
	 */
	public static IntegerKeyMap toIntegerKeyMap(final Map map) {
		return new WrappingNumberMap(map);
	}

	/**
	 * Ɏw肳ꂽ}bvStringKeyMap̃C^tF[Xǉ܂B
	 * 
	 * @param map
	 *            ΏۂƂȂMapIuWFNg
	 * @return
	 */
	public static StringKeyMap toStringKeyMap(final Map map) {
		return new WrappingStringKeyMap(map);
	}

}

class WrappingNumberMap extends MapWrapper implements IntegerKeyMap {

	/**
	 * @param wrapped
	 */
	public WrappingNumberMap(Map wrapped) {
		super(wrapped);
	}

	public void put(int number, Object value) {
		put(new Integer(number), value);
	}

	public void put(Integer key, Object value) {
		super.put(key, value);
	}

	public Object get(int number) {
		return get(new Integer(number));
	}

	public Object get(Integer key) {
		return super.get(key);
	}

	public Object remove(int number) {
		return remove(new Integer(number));
	}

	public Object remove(Integer key) {
		return super.remove(key);
	}

}

class WrappingStringKeyMap extends MapWrapper implements StringKeyMap {

	/**
	 * @param wrapped
	 */
	public WrappingStringKeyMap(Map wrapped) {
		super(wrapped);
	}

	public Object get(String key) {
		return super.get(key);
	}

	public void put(String key, Object value) {
		super.put(key, value);
	}

	public Object remove(String key) {
		return super.remove(key);
	}

	public List sortedKeys() {
		final List result = new ArrayList();
		result.addAll(this.keySet());
		Collections.sort(result);
		return result;
	}

}