/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/05 2:15:24
 */
package org.asyrinx.brownie.core.collection.calc;

import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.core.lang.NumberUtils;

/**
 * @author akima
 */
public abstract class Selection extends Calculation.AbstractCalculation {

    public Number calculate(List list) {
        if (list.size() == 0)
            return new Integer(0);
        if (list.size() == 1)
            return NumberUtils.toNumber(list.get(0));
        double result = NumberUtils.toNumber(list.get(0)).doubleValue();
        for (Iterator iter = list.iterator(); iter.hasNext();) {
            final Number number = NumberUtils.toNumber(iter.next());
            result = select(number.doubleValue(), result);
        }
        return NumberUtils.toMinimunNumberObject(result);
    }

    abstract protected double select(double val1, double val2);

}