/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/08 23:13:12
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * @author akima
 */
public interface MapTreeKey extends Serializable {

    public Object[] toArray();

    public int getDepth();

    public static final MapTreeKey NULL = new MapTreeKey() {

        final Object[] result = new Object[0];

        public Object[] toArray() {
            return result;
        }

        public int getDepth() {
            return 0;
        }
    };

    public static class Default implements MapTreeKey {
        public Default(Object[] key) {
            this.key = key;
        }

        private final Object[] key;

        public Object[] toArray() {
            return this.key;
        }

        public int getDepth() {
            return key.length;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MapTreeKey) {
                final MapTreeKey mapTreeKey = (MapTreeKey) obj;
                return new EqualsBuilder().append(this.key, mapTreeKey.toArray()).isEquals();
            } else if (obj instanceof Object[]) {
                return new EqualsBuilder().append(this.key, (Object[]) obj).isEquals();
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.key).hashCode();
        }
    }

    public static class Wrapper implements MapTreeKey {
        public Wrapper(MapTreeKey wrapped) {
            this.wrapped = wrapped;
        }

        protected final MapTreeKey wrapped;

        public int getDepth() {
            return wrapped.getDepth();
        }

        public Object[] toArray() {
            return wrapped.toArray();
        }
    }

    public static final class Buffered extends Wrapper {
        public Buffered(MapTreeKey wrapped) {
            super(wrapped);
        }

        private Object[] result = null;

        public Object[] toArray() {
            if (result == null)
                result = super.toArray();
            return result;
        }

        public int getDepth() {
            return toArray().length;
        }
    }

}