/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/05
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.util.Iterator;
import java.util.Map;

import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.Closure;

/**
 * Mapɂc[\ɑ΂ANV\NX̒ۃNXłB
 * MapTreeIuWFNgƊ֌W܂ÃNXMapTreeIuWFNggp܂B
 * 
 * @author akima
 */
public class MapTreeVisitor {

    /**
     *  
     */
    public MapTreeVisitor(Map root, Closure closure) {
        super();
        this.root = root;
        this.closure = closure;
    }

    /**
     *  
     */
    public MapTreeVisitor(Map root) {
        this(root, null);
    }

    protected final Map root;

    private Closure closure;

    protected final ArrayStack keyStack = new ArrayStack();

    public void execute() {
        keyStack.clear();
        doOnMap(root);
    }

    public void doOnMap(Map map) {
        final Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = map.get(key);
            keyStack.push(key);
            try {
                if (value instanceof Map) {
                    doOnMap((Map) value);
                } else {
                    doOnLeaf(value);
                }
            } finally {
                keyStack.pop();
            }
        }
    }

    public void doOnLeaf(Object value) {
        if (closure != null)
            closure.execute(value);
    }

    /**
     * @return
     */
    public Closure getClosure() {
        return closure;
    }

}