/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.collection.wrapper;

import java.util.Iterator;

import org.asyrinx.brownie.core.util.Wrapper;

/**
 * @author Akima
 */
public class IteratorWrapper extends Wrapper implements Iterator {

	/**
	 * Constructor for IteratorWrapper.
	 */
	public IteratorWrapper(Iterator iterator) {
		super(iterator);
		this.iterator = iterator;
	}

	protected final Iterator iterator;

	/**
	 * @see java.util.Iterator#hasNext()
	 */
	public boolean hasNext() {
		return iterator.hasNext();
	}

	/**
	 * @see java.util.Iterator#next()
	 */
	public Object next() {
		return iterator.next();
	}

	/**
	 * @see java.util.Iterator#remove()
	 */
	public void remove() {
		iterator.remove();
	}

}