/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.collection.wrapper;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.asyrinx.brownie.core.util.Wrapper;

/**
 * 
 * @author akima
 */
public class MapWrapper extends Wrapper implements Map {

	/**
	 * Constructor for MapWrapper.
	 */
	public MapWrapper(Map impl) {
		super(impl);
		this.impl = impl;
	}

	protected final Map impl;

	/**
	 * @see java.util.Map#size()
	 */
	public int size() {
		return impl.size();
	}

	/**
	 * @see java.util.Map#isEmpty()
	 */
	public boolean isEmpty() {
		return impl.isEmpty();
	}

	/**
	 * @see java.util.Map#containsKey(Object)
	 */
	public boolean containsKey(Object key) {
		return impl.containsKey(key);
	}

	/**
	 * @see java.util.Map#containsValue(Object)
	 */
	public boolean containsValue(Object value) {
		return impl.containsValue(value);
	}

	/**
	 * @see java.util.Map#get(Object)
	 */
	public Object get(Object key) {
		return impl.get(key);
	}

	/**
	 * @see java.util.Map#put(Object, Object)
	 */
	public Object put(Object key, Object value) {
		return impl.put(key, value);
	}

	/**
	 * @see java.util.Map#remove(Object)
	 */
	public Object remove(Object key) {
		return impl.remove(key);
	}

	/**
	 * @see java.util.Map#putAll(Map)
	 */
	public void putAll(Map t) {
		impl.putAll(t);
	}

	/**
	 * @see java.util.Map#clear()
	 */
	public void clear() {
		impl.clear();
	}

	/**
	 * @see java.util.Map#keySet()
	 */
	public Set keySet() {
		return impl.keySet();
	}

	/**
	 * @see java.util.Map#values()
	 */
	public Collection values() {
		return impl.values();
	}

	/**
	 * @see java.util.Map#entrySet()
	 */
	public Set entrySet() {
		return impl.entrySet();
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return impl.toString();
	}

}