/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/20 17:32:09
 */
package org.asyrinx.brownie.core.csv;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.asyrinx.brownie.core.io.sf.StreamFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.brownie.core.lang.enum.ValuedEnum;

/**
 * @author akima
 */
public class PropertySVBeanMapper implements SVBeanMapper {

	/**
	 *  
	 */
	public PropertySVBeanMapper(String mappedClassName, Properties properties) {
		super();
		this.properties = properties;
		this.mappedClassName = mappedClassName;
	}

	/**
	 *  
	 */
	public PropertySVBeanMapper(String mappedClassName, String propertyContext)
			throws IOException {
		this(mappedClassName, loadProperties(propertyContext));
	}

	private static Properties loadProperties(String propertyContext)
			throws IOException {
		final StreamFactory streamFactory = StreamFactoryFacade.newFacade();
		final InputStream inputStream = streamFactory.newInput(propertyContext);
		final Properties properties = new Properties();
		properties.load(inputStream);
		return properties;
	}

	protected final Properties properties;

	protected final String mappedClassName;

	private DateFormat dateFormat = DateFormat.getDateInstance();

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.asyrinx.brownie.core.text.SVBeanMapper#loadBean(java.util.List)
	 */
	public Object loadBean(List values) {
		final Object bean = getBean();
		loadPropertyValues(values, bean);
		return bean;
	}

	protected void loadPropertyValues(List values, final Object bean) {
		final Set keys = properties.keySet();
		final Map valueMap = new HashMap();
		try {
			for (Iterator iter = keys.iterator(); iter.hasNext();) {
				final Object key = iter.next();
				final String propName = String.valueOf(properties.get(key));
				final int keyIndex = NumberUtils.toInt(key, -1);
				if ((keyIndex < 0) || (keyIndex > values.size() - 1))
					throw new NestableRuntimeException("skeył: " + key);
				Object value = values.get(keyIndex);
				value = loadPropertyObject(bean, propName, value);
				valueMap.put(propName, value);
			}
			BeanUtils.populate(bean, valueMap);
		} catch (Exception e) {
			throw new NestableRuntimeException("bean: '" + bean
					+ "', valueMap: " + valueMap, e);
		}
	}

	protected Object loadPropertyObject(final Object bean,
			final String propName, Object value) throws IllegalAccessException,
			InvocationTargetException, NoSuchMethodException, ParseException,
			ClassNotFoundException {
		final Class propType = PropertyUtils.getPropertyType(bean, propName);
		if (Date.class.isAssignableFrom(propType)) {
			value = dateFormat.parse(String.valueOf(value));
		} else if (ValuedEnum.class.isAssignableFrom(propType)) {
			//forNameĂȂƃNX[hȂƂ
			Class.forName(propType.getName());
			value = ValuedEnum.getEnumByName(propType, String.valueOf(value));
		}
		return value;
	}

	protected Object getBean() {
		try {
			return ClassUtils.newObject(mappedClassName, null);
		} catch (InstantiationException e) {
			throw new NestableRuntimeException(e);
		}
	}

	/**
	 * @return
	 */
	public DateFormat getDateFormat() {
		return dateFormat;
	}

	/**
	 * @param format
	 */
	public void setDateFormat(DateFormat format) {
		dateFormat = format;
	}

}