/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/20 17:20:07
 */
package org.asyrinx.brownie.core.csv;

import java.util.List;

/**
 * @author akima
 */
public class SVBeanMapperDispatcherMapper implements SVBeanMapper {

	/**
	 *  
	 */
	public SVBeanMapperDispatcherMapper(SVBeanMapperDispatcher dispatcher) {
		super();
		this.dispatcher = dispatcher;
	}

	private final SVBeanMapperDispatcher dispatcher;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.asyrinx.brownie.core.text.SVBeanMapper#loadBean(java.util.List)
	 */
	public Object loadBean(List properties) {
		final SVBeanMapper mapper = dispatch(properties);
		if (mapper != null)
			return mapper.loadBean(properties);
		else
			return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.asyrinx.brownie.core.csv.SVBeanMapperDispatcher#dispatch(java.util.List)
	 */
	public SVBeanMapper dispatch(List properties) {
		return dispatcher.dispatch(properties);
	}

}