/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author Akima
 */
public class SimpleFileStreamFactory extends AbstractFileStreamFactory {

    /**
     * Constructor for SimpleFileStreamLoader.
     */
    public SimpleFileStreamFactory() {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#newInput(java.lang.Object)
     */
    public InputStream newInput(Object key) throws IOException {
        if (key instanceof File) {
            return new FileInputStream((File) key);
        } else {
            return new FileInputStream(keyToString(key));
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#newOutput(java.lang.Object)
     */
    public OutputStream newOutput(Object key) throws IOException {
        if (key instanceof File) {
            return new FileOutputStream((File) key);
        } else {
            return new FileOutputStream(keyToString(key));
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#getCaption()
     */
    public String getCaption() {
        return "file system";
    }

}