/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/28 1:50:05
 */
package org.asyrinx.brownie.core.lang;

import java.lang.reflect.Field;

/**
 * @author takeshi
 */
public class FieldUtils {

    public static Object getValue(Object target, String fieldName) throws IllegalArgumentException,
            IllegalAccessException, NoSuchFieldException {
        if (target instanceof Class)
            return getStaticValue((Class) target, fieldName);
        else
            return getValue(target, target.getClass(), fieldName);
    }

    public static Object getStaticValue(Class clazz, String fieldName) throws IllegalArgumentException,
            IllegalAccessException, NoSuchFieldException {
        return getValue(null, clazz, fieldName);
    }

    public static Object getValue(Object target, Class clazz, String fieldName) throws IllegalArgumentException,
            IllegalAccessException, NoSuchFieldException {
        final Field field = getField(clazz, fieldName);
        if (field == null)
            throw new NoSuchFieldException(clazz.getName() + "#" + fieldName);
        return field.get(target);
    }

    public static Field getField(Class clazz, String fieldName) {
        Field result = getBySuperClass(clazz, fieldName);
        if (result != null)
            return result;
        result = getByInterfacesOfClass(clazz, fieldName);
        if (result != null)
            return result;
        return null;
    }

    private static Field getFieldImpl(Class clazz, String fieldName) {
        if (clazz == null)
            return null;
        final Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; i++) {
            if (fields[i].getName().equals(fieldName))
                return fields[i];
        }
        return null;
    }

    private static Field getBySuperClass(Class key, String fieldName) {
        for (Class current = key; current != null; current = current.getSuperclass()) {
            final Field result = getFieldImpl(current, fieldName);
            if (result != null)
                return result;
        }
        return null;
    }

    private static Field getByInterfacesOfClass(Class key, String fieldName) {
        for (Class current = key; current != null; current = current.getSuperclass()) {
            final Field result = getByInterfaces(current.getInterfaces(), fieldName);
            if (result != null)
                return result;
        }
        return null;
    }

    private static Field getByInterfaces(Class[] interfaces, String fieldName) {
        for (int i = 0; i < interfaces.length; i++) {
            Field result = getFieldImpl(interfaces[i], fieldName);
            if (result != null)
                return result;
            result = getByInterfaces(interfaces[i].getInterfaces(), fieldName);
            if (result != null)
                return result;
        }
        return null;
    }

}