/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/02
 */
package org.asyrinx.brownie.core.log;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * w肳ꂽOxŃOo͂LogNX̃bp[łB <br>
 * ɁAO̐ݒt@CŃOxw肳悤ȏꍇ gp܂B <br>
 * ̃NXAvP[V璼ڎgp邱Ƃ͂܂܂B <br>
 * 
 * @author akima
 */
public class DispatchLog implements Log {

	public static final String LEVEL_FATAL = "fatal";

	public static final String LEVEL_ERROR = "error";

	public static final String LEVEL_WARN = "warn";

	public static final String LEVEL_INFO = "info";

	public static final String LEVEL_DEBUG = "debug";

	public static final String LEVEL_TRACE = "trace";

	public static final String DEFAULT_LEVEL = LEVEL_DEBUG;

	/**
	 * RXgN^ <br>
	 * 
	 * @param log
	 *            ۂ̃Oo͐ƂȂLogIuWFNg
	 */
	public DispatchLog() {
		this(LogFactory.getLog(DispatchLog.class), DEFAULT_LEVEL);
	}

	/**
	 * RXgN^ <br>
	 * 
	 * @param log
	 *            ۂ̃Oo͐ƂȂLogIuWFNg
	 */
	public DispatchLog(Log log) {
		this(log, DEFAULT_LEVEL);
	}

	/**
	 * RXgN^ <br>
	 * 
	 * @param log
	 *            ۂ̃Oo͐ƂȂLogIuWFNg
	 * @param
	 */
	public DispatchLog(Log log, String defaultLevel) {
		super();
		this.log = log;
		setDefaultLevel(defaultLevel);
	}

	private Log log;

	/**
	 * ftHgOx̃ftHgl"debug"łB
	 */
	private String defaultLevel = "debug";

	/**
	 * ftHgOxŃOo͂܂B
	 * 
	 * @param message
	 *            o̓bZ[W
	 * @param t
	 *            ֘AOAG[
	 */
	public void log(Object message, Throwable t) {
		log(defaultLevel, message, t);
	}

	/**
	 * ftHgOxŃOo͂܂B
	 * 
	 * @param message
	 *            o̓bZ[W
	 */
	public void log(Object message) {
		log(defaultLevel, message);
	}

	/**
	 * w肳ꂽOxŃOo͂܂B
	 * 
	 * @param level
	 *            Ox
	 * @param message
	 *            o̓bZ[W
	 * @param t
	 *            ֘AOAG[
	 */
	public void log(String level, Object message, Throwable t) {
		if (LEVEL_FATAL.equals(level)) {
			log.fatal(message, t);
		} else if (LEVEL_ERROR.equals(level)) {
			log.error(message, t);
		} else if (LEVEL_WARN.equals(level)) {
			log.warn(message, t);
		} else if (LEVEL_INFO.equals(level)) {
			log.info(message, t);
		} else if (LEVEL_DEBUG.equals(level)) {
			log.debug(message, t);
		} else if (LEVEL_TRACE.equals(level)) {
			log.trace(message, t);
		}
	}

	/**
	 * w肳ꂽOxŃOo͂܂B
	 * 
	 * @param level
	 *            Ox
	 * @param message
	 *            o̓bZ[W
	 */
	public void log(String level, Object message) {
		if (LEVEL_FATAL.equals(level)) {
			log.fatal(message);
		} else if (LEVEL_ERROR.equals(level)) {
			log.error(message);
		} else if (LEVEL_WARN.equals(level)) {
			log.warn(message);
		} else if (LEVEL_INFO.equals(level)) {
			log.info(message);
		} else if (LEVEL_DEBUG.equals(level)) {
			log.debug(message);
		} else if (LEVEL_TRACE.equals(level)) {
			log.trace(message);
		}
	}

	/**
	 * @return
	 */
	public Log getLog() {
		return log;
	}

	/**
	 * @param log
	 */
	public void setLog(Log log) {
		this.log = log;
	}

	/**
	 * ftHgOxgetterłB
	 * 
	 * @return
	 */
	public String getDefaultLevel() {
		return defaultLevel;
	}

	/**
	 * ftHgOxsetterłB
	 * 
	 * @param string
	 */
	public void setDefaultLevel(String string) {
		defaultLevel = string;
	}

	/**
	 * @param message
	 */
	public void debug(Object message) {
		log.debug(message);
	}

	/**
	 * @param message
	 * @param t
	 */
	public void debug(Object message, Throwable t) {
		log.debug(message, t);
	}

	/**
	 * @param message
	 */
	public void error(Object message) {
		log.error(message);
	}

	/**
	 * @param message
	 * @param t
	 */
	public void error(Object message, Throwable t) {
		log.error(message, t);
	}

	/**
	 * @param message
	 */
	public void fatal(Object message) {
		log.fatal(message);
	}

	/**
	 * @param message
	 * @param t
	 */
	public void fatal(Object message, Throwable t) {
		log.fatal(message, t);
	}

	/**
	 * @param message
	 */
	public void info(Object message) {
		log.info(message);
	}

	/**
	 * @param message
	 * @param t
	 */
	public void info(Object message, Throwable t) {
		log.info(message, t);
	}

	/**
	 * @return
	 */
	public boolean isDebugEnabled() {
		return log.isDebugEnabled();
	}

	/**
	 * @return
	 */
	public boolean isErrorEnabled() {
		return log.isErrorEnabled();
	}

	/**
	 * @return
	 */
	public boolean isFatalEnabled() {
		return log.isFatalEnabled();
	}

	/**
	 * @return
	 */
	public boolean isInfoEnabled() {
		return log.isInfoEnabled();
	}

	/**
	 * @return
	 */
	public boolean isTraceEnabled() {
		return log.isTraceEnabled();
	}

	/**
	 * @return
	 */
	public boolean isWarnEnabled() {
		return log.isWarnEnabled();
	}

	/**
	 * @param message
	 */
	public void trace(Object message) {
		log.trace(message);
	}

	/**
	 * @param message
	 * @param t
	 */
	public void trace(Object message, Throwable t) {
		log.trace(message, t);
	}

	/**
	 * @param message
	 */
	public void warn(Object message) {
		log.warn(message);
	}

	/**
	 * @param message
	 * @param t
	 */
	public void warn(Object message, Throwable t) {
		log.warn(message, t);
	}

}