/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/20 17:22:01
 */
package org.asyrinx.brownie.core.query.exp;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * @author takeshi
 */
public abstract class AbstractValuedExpression implements IValuedExpression {

    /**
     *  
     */
    protected AbstractValuedExpression() {
        super();
    }

    /**
     *  
     */
    protected AbstractValuedExpression(String operator, Object value) {
        super();
        this.operator = operator;
        this.value = value;
    }

    private String operator;

    private Object value;

    /**
     * @return Returns the operator.
     */
    public String getOperator() {
        return operator;
    }

    /**
     * @param operator
     *            The operator to set.
     */
    public void setOperator(String operator) {
        this.operator = operator;
    }

    /**
     * @return Returns the value.
     */
    public Object getValue() {
        return value;
    }

    /**
     * @param value
     *            The value to set.
     */
    public void setValue(Object value) {
        this.value = value;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof IValuedExpression))
            return false;
        final IValuedExpression other = (IValuedExpression) obj;
        return new EqualsBuilder().append(this.getOperator(), other.getOperator()).append(
                this.getValue(), other.getValue()).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        return new HashCodeBuilder().append(this.getOperator()).append(this.getValue())
                .toHashCode();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return getOperator() + " " + getValue();
    }
}