/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/19 23:53:09
 */
package org.asyrinx.brownie.core.query.model;

/**
 * @author takeshi
 */
public class Field {

    /**
     *  
     */
    public Field() {
        super();
    }

    public Field(Class type, String rdbName, String javaName) {
        this(null, type, rdbName, javaName, null);
    }

    public Field(Class type, String rdbName, String javaName, String format) {
        this(null, type, rdbName, javaName, format);
    }

    public Field(Table parent, Class type, String rdbName, String javaName) {
        this(parent, type, rdbName, javaName, null);
    }

    public Field(Table parent, Class type, String rdbName, String javaName, String format) {
        super();
        this.rdbName = rdbName;
        this.javaName = javaName;
        this.type = type;
        this.format = format;
        this.setParent(parent);
    }

    private Table parent = null;

    private Class type = null;

    private String format = null;

    private String rdbName = null;

    /**
     * @return Returns the rdbName.
     */
    public String getRdbName() {
        return rdbName;
    }

    /**
     * @param rdbName
     *            The rdbName to set.
     */
    public void setRdbName(String name) {
        this.rdbName = name;
    }

    private String javaName;

    /**
     * @return Returns the javaName.
     */
    public String getJavaName() {
        return javaName;
    }

    /**
     * @param javaName
     *            The javaName to set.
     */
    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    /**
     * @return Returns the parent.
     */
    public Table getTable() {
        return parent;
    }

    /**
     * @param parent
     *            The parent to set.
     */
    public void setParent(Table parent) {
        this.parent = parent;
        if ((this.parent != null) && !this.parent.contains(this))
            this.parent.add(this);
    }

    /**
     * @return Returns the type.
     */
    public Class getType() {
        return type;
    }

    /**
     * @param type
     *            The type to set.
     */
    public void setType(Class type) {
        this.type = type;
    }

    /**
     * @return Returns the format.
     */
    public String getFormat() {
        return format;
    }

    /**
     * @param format
     *            The format to set.
     */
    public void setFormat(String format) {
        this.format = format;
    }

    /*
     * @see org.asyrinx.brownie.core.query.model.IField#getOwner()
     */
    public Table getOwner() {
        return getTable();
    }

    public FieldAlias alias() {
        return alias(this.getRdbName());
    }

    public FieldAlias alias(String fieldAliasName) {
        final TableAlias ta = this.getOwner().alias();
        return ta.getField(this, fieldAliasName);
    }

    /**
     * @return
     */
    public String getAliasName() {
        return this.getRdbName();
    }

}