/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/09 12:04:18
 */
package org.asyrinx.brownie.core.resource.impl;

import java.util.HashMap;
import java.util.Map;

import org.asyrinx.brownie.core.resource.MessageResource;
import org.asyrinx.brownie.core.resource.ParameterizedMessageResource;
import org.asyrinx.brownie.core.text.MapMessageFormat;

/**
 * @author takeshi
 */
public class ParameterizedMessageResourceImpl extends MessageResourceWrapper implements
        ParameterizedMessageResource {

    /**
     *  
     */
    public ParameterizedMessageResourceImpl(MessageResource messageResource) {
        super(messageResource);
    }

    public String getMessage(String key, Map arguments) {
        final MapMessageFormat format = getFormat(key);
        return format.format(arguments);
    }

    private Map formats = new HashMap();

    /**
     * @param key
     * @return
     */
    private MapMessageFormat getFormat(String key) {
        MapMessageFormat result = (MapMessageFormat) this.formats.get(key);
        if (result == null) {
            result = new MapMessageFormat(getMessage(key));
            this.formats.put(key, result);
        }
        return result;
    }

}