/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/15
 */
package org.asyrinx.brownie.core.sql;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

import org.asyrinx.brownie.core.collection.IntegerKeyMap;
import org.asyrinx.brownie.core.collection.StringKeyMap;

/**
 * PreparedStatementŎgpSQL?uAs\SQLɕϊNXłB <br>
 * {I?Ylɕϊ邾łAl̃NXɂĈȉ̏s܂B <br>
 * iStringIuWFNgjquotevpeBŎw肳ꂽň͂܂܂B <br>
 * tiDateIuWFNgjformatForDatevpeBŎw肳ꂽtH[}bgŕɕϊAquotevpeBŎw肳ꂽň͂܂܂B
 * <br>
 * iTimeIuWFNgjformatForTimevpeBŎw肳ꂽtH[}bgŕɕϊAquotevpeBŎw肳ꂽň͂܂܂B
 * <br>
 * TimestampIuWFNgformatForTimestampvpeBŎw肳ꂽtH[}bgŕɕϊAquotevpeBŎw肳ꂽň͂܂܂B
 * <br>
 * 
 * @author akima
 */
public class SqlReplacer {

	/**
	 *  
	 */
	public SqlReplacer() {
		super();
	}

	private DateFormat formatForDate = new SimpleDateFormat("yyyy/MM/dd");

	private DateFormat formatForTime = new SimpleDateFormat("HH:mm:ss");

	private DateFormat formatForTimestamp = new SimpleDateFormat(
			"yyyy/MM/dd HH:mm:ss");

	private char quote = DEFAULT_QUOTE;

	private static final char DEFAULT_QUOTE = '\'';

	/**
	 * ϊs܂B
	 * 
	 * @param sql
	 *            ?܂SQL
	 * @param parameters
	 *            ԍƊ֘Atꂽp[^Q
	 * @return ϊꂽSQL
	 */
	public String execute(String sql, IntegerKeyMap parameters) {
		final StringBuffer result = new StringBuffer(100);
		final int lastParameterIndex = getLastParameterIndex(parameters);
		int paramIndex = 0;
		boolean inSingleQuote = false;
		boolean inDoubleQuote = false;
		for (int i = 0; i < sql.length(); i++) {
			final char currChar = sql.charAt(i);
			switch (currChar) {
			case '?':
				if (inSingleQuote || inDoubleQuote) {
					result.append(currChar);
					break;
				}
				paramIndex++;
				if (paramIndex > lastParameterIndex)
					paramIndex = 1;
				final Object value = parameters.get(paramIndex);
				appendValue(result, value);
				break;
			case '\'':
				if (!inDoubleQuote)
					inSingleQuote = !inSingleQuote;
				result.append(currChar);
				break;
			case '"':
				if (!inSingleQuote)
					inDoubleQuote = !inDoubleQuote;
				result.append(currChar);
				break;
			default:
				result.append(currChar);
				break;
			}
		}
		return result.toString();
	}

	/**
	 * ϊs܂B
	 * 
	 * @param sql
	 * @param parameters
	 *            ԍƊ֘Atꂽp[^Q
	 * @return ϊꂽSQL
	 */
	public String execute(String sql, StringKeyMap parameters) {
		return sql + " parameters=" + parameters;
	}

	/**
	 * @param parameters
	 * @return
	 */
	private int getLastParameterIndex(IntegerKeyMap parameters) {
		final Set keySet = parameters.keySet();
		final List keyList = new ArrayList();
		keyList.addAll(keySet);
		Collections.sort(keyList);
		if (keyList.isEmpty())
			return 0;
		final Object value = keyList.get(keyList.size() - 1);
		if (value instanceof Number)
			return ((Number) value).intValue();
		return 0;
	}

	private void appendValue(StringBuffer dest, Object value) {
		if (value == null) {
			dest.append("null");
			return;
		}
		if (needQuote(value))
			dest.append(getQuote());

		if (value instanceof String)
			dest.append(toString((String) value));
		else if (value instanceof Timestamp)
			dest.append(toString((Timestamp) value));
		else if (value instanceof Time)
			dest.append(toString((Time) value));
		else if (value instanceof Date)
			dest.append(toString((Date) value));
		else
			dest.append(toString(value));

		if (needQuote(value))
			dest.append(getQuote());
	}

	private boolean needQuote(Object value) {
		return (value instanceof String) || (value instanceof Date)
				|| (value instanceof Time) || (value instanceof Timestamp);
	}

	private String toString(Object value) {
		return String.valueOf(value);
	}

	private String toString(String value) {
		return value;
	}

	private String toString(Time value) {
		return String.valueOf(formatForTime.format(value));
	}

	private String toString(Date value) {
		return String.valueOf(formatForDate.format(value));
	}

	private String toString(Timestamp value) {
		return formatForTimestamp.format(new Date(value.getTime()));
	}

	/**
	 * ϊs܂B DateATimeATimestampp̃tH[}bg̓ftHĝ̂gp܂B
	 * 
	 * @param sql
	 *            ?܂SQL
	 * @param parameters
	 *            ԍƊ֘Atꂽp[^Q
	 * @return ϊꂽSQL
	 */
	public static String replacePreparedParmaeters(String sql,
			IntegerKeyMap parameters) {
		final SqlReplacer replacer = new SqlReplacer();
		return replacer.execute(sql, parameters);
	}

	/**
	 * ϊs܂B DateATimeATimestampp̃tH[}bg̓ftHĝ̂gp܂B
	 * 
	 * @param sql
	 *            ?܂SQL
	 * @param parameters
	 *            ԍƊ֘Atꂽp[^Q
	 * @param formatForDate
	 *            Datep̃tH[}bg
	 * @param formatForTime
	 *            Timep̃tH[}bg
	 * @param formatForTimestamp
	 *            Timestampp̃tH[}bg
	 * @return ϊꂽSQL
	 */
	public static String replacePreparedParmaeters(String sql,
			IntegerKeyMap parameters, String formatForDate,
			String formatForTime, String formatForTimestamp) {
		final SqlReplacer replacer = new SqlReplacer();
		replacer.setFormatForDate(new SimpleDateFormat(formatForDate));
		replacer.setFormatForTime(new SimpleDateFormat(formatForTime));
		replacer
				.setFormatForTimestamp(new SimpleDateFormat(formatForTimestamp));
		return replacer.execute(sql, parameters);
	}

	/**
	 * Datep̃tH[}bg
	 * 
	 * @return
	 */
	public DateFormat getFormatForDate() {
		return formatForDate;
	}

	/**
	 * Timep̃tH[}bg
	 * 
	 * @return
	 */
	public DateFormat getFormatForTime() {
		return formatForTime;
	}

	/**
	 * Timestampp̃tH[}bg
	 * 
	 * @return
	 */
	public DateFormat getFormatForTimestamp() {
		return formatForTimestamp;
	}

	/**
	 * Datep̃tH[}bg
	 * 
	 * @param format
	 */
	public void setFormatForDate(DateFormat format) {
		formatForDate = format;
	}

	/**
	 * Timep̃tH[}bg
	 * 
	 * @param format
	 */
	public void setFormatForTime(DateFormat format) {
		formatForTime = format;
	}

	/**
	 * Timestampp̃tH[}bg
	 * 
	 * @param format
	 */
	public void setFormatForTimestamp(DateFormat format) {
		formatForTimestamp = format;
	}

	/**
	 * AtAϊ̍ۂɎgpNH[e[V
	 * 
	 * @return
	 */
	public char getQuote() {
		return quote;
	}

	/**
	 * AtAϊ̍ۂɎgpNH[e[V
	 * 
	 * @param c
	 */
	public void setQuote(char c) {
		quote = c;
	}

}