/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 23:02:41
 */
package org.asyrinx.brownie.core.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.asyrinx.brownie.core.lang.PropertyUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;

/**
 * MapMessageFormat replace delimitered strings to values of Map object. If obj
 * parameter of format method isn't Map, obj will be converted to Map by using
 * PropertyUtils. <br/><b>example </b> <br/>"property '${prop1}' must be
 * ${value1}" + #{"prop1":"foo", "value1":"boo" }<br/>"property 'foo' must be
 * boo"
 * 
 * MapMessageFormat doesn't support parse method.
 * 
 * @author takeshi
 */
public class MapMessageFormat extends Format {

    /**
     *  
     */
    public MapMessageFormat(String pattern) {
        this(pattern, "${", "}");
    }

    /**
     *  
     */
    public MapMessageFormat(String pattern, String delimiterBegin, String delimiterEnd) {
        super();
        this.pattern = pattern;
        this.delimiterBegin = delimiterBegin;
        this.delimiterEnd = delimiterEnd;
        this.parameters = extractParameters();
    }

    private final List parameters;

    private final String pattern;

    private final String delimiterBegin;

    private final String delimiterEnd;

    public Object parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException();
    }

    protected List extractParameters() {
        final List result = new ArrayList();
        int idxEnd = -delimiterEnd.length();
        int idxBegin;
        while ((idxBegin = pattern.indexOf(delimiterBegin, idxEnd + delimiterEnd.length())) > -1) {
            idxEnd = pattern.indexOf(delimiterEnd, idxBegin + delimiterBegin.length());
            if (idxEnd < 0)
                break;
            final String parameter = pattern.substring(idxBegin + delimiterBegin.length(), idxEnd);
            result.add(parameter);
        }
        return result;
    }

    public final String format(Map attributes) {
        return format(attributes, new StringBuffer(), null).toString();
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        format(toMap(obj), toAppendTo);
        return toAppendTo;
    }

    protected Map toMap(Object obj) {
        if (obj == null) {
            //throw new NullPointerException();
            return Collections.EMPTY_MAP;
        }
        if (obj instanceof Map)
            return (Map) obj;
        try {
            return PropertyUtils.describe(obj);
        } catch (Exception e) {
            throw new UnsupportedClassRuntimeException("failed to get java.util.Map from " + obj);
        }
    }

    public void format(Map attributes, StringBuffer toAppendTo) {
        toAppendTo.append(this.getPattern());
        for (Iterator i = this.parameters.iterator(); i.hasNext();) {
            final String parameter = (String) i.next();
            final String attribute = toStringAttribute(attributes.get(parameter), parameter);
            replaceAll(toAppendTo, parameter, attribute);
        }
    }

    protected String toStringAttribute(Object attribute, String parameter) {
        return (attribute != null) ? String.valueOf(attribute) : delimiterBegin + parameter
                + delimiterEnd;
    }

    /**
     * @param toAppendTo
     * @param parameter
     * @param attribute
     */
    protected void replaceAll(StringBuffer toAppendTo, String parameter, String attribute) {
        parameter = delimiterBegin + parameter + delimiterEnd;
        int parameterLength = parameter.length();
        int idx = toAppendTo.toString().indexOf(parameter);
        while (idx > -1) {
            toAppendTo.replace(idx, idx + parameterLength, attribute);
            idx = toAppendTo.toString().indexOf(parameter, idx + attribute.length());
        }
    }

    public String getPattern() {
        return pattern;
    }

    public String getDelimiterBegin() {
        return delimiterBegin;
    }

    public String getDelimiterEnd() {
        return delimiterEnd;
    }

}