/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/07 7:31:06
 */
package org.asyrinx.brownie.core.util;

import java.util.Comparator;

/**
 * @author akima
 */
public class ArrayComparator implements Comparator {

    public ArrayComparator() {
        this(new NumberComparator());
    }

    public ArrayComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    private final Comparator comparator;

    /*
     * (non-Javadoc)
     * 
     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
     */
    public int compare(Object o1, Object o2) {
        if (!o1.getClass().isArray() || !o2.getClass().isArray())
            throw new IllegalArgumentException("object must be array");
        final Object[] array1 = (Object[]) o1;
        final Object[] array2 = (Object[]) o2;
        for (int i = 0; i < array1.length; i++) {
            if (i >= array2.length)
                return 1;
            final int r = comparator.compare(array1[i], array2[i]);
            if (r != 0)
                return r;
        }
        if (array1.length < array2.length)
            return -1;
        else
            return 0;
    }

}