/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.util;

import java.util.Date;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author akima
 */
public class DateRange {

    /**
     *  
     */
    public DateRange(Date from, Date to) {
        super();
        this.from = (from != null) ? from : DateUtils.getInfinitePast();
        this.to = (to != null) ? to : DateUtils.getInfiniteFuture();
    }

    private final Date from;

    private final Date to;

    /**
     * @return
     */
    public Date getFrom() {
        return from;
    }

    /**
     * @return
     */
    public Date getTo() {
        return to;
    }

    /**
     * <p>
     * Tests whether the specified <code>date</code> occurs within this range
     * using <code>double</code> comparison.
     * </p>
     * 
     * @param date
     *            the date to test
     * @return <code>true</code> if the specified date occurs within this
     *         range; otherwise, <code>false</code>
     */
    public boolean includesDate(Date date) {
        if (date == null) {
            return false;
        } else {
            return date.after(this.getFrom()) && date.before(this.getTo());
        }
    }

    /**
     * <p>
     * Tests whether the specified range occurs entirely within this range using
     * <code>double</code> comparison.
     * </p>
     * 
     * @param range
     *            the range to test
     * @return <code>true</code> if the specified range occurs entirely within
     *         this range; otherwise, <code>false</code>
     */
    public boolean includesRange(DateRange range) {
        if (range == null) {
            return false;
        } else {
            return includesDate(range.getFrom()) && includesDate(range.getTo());
        }
    }

    /**
     * <p>
     * Tests whether the specified range overlaps with this range using
     * <code>double</code> comparison.
     * </p>
     * 
     * @param range
     *            the range to test
     * @return <code>true</code> if the specified range overlaps with this
     *         range; otherwise, <code>false</code>
     */
    public boolean overlaps(DateRange range) {
        if (range == null) {
            return false;
        } else {
            return range.includesDate(this.getFrom()) || range.includesDate(this.getTo()) || this.includesRange(range);
        }
    }

    /**
     * @param obj
     * @return
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        } else if (!(obj instanceof DateRange)) {
            return false;
        } else {
            final DateRange range = (DateRange) obj;
            return new EqualsBuilder().append(this.getFrom(), range.getFrom()).append(this.getTo(), range.getTo())
                    .isEquals();
        }
    }

    /**
     * @return
     */
    public int hashCode() {
        return new HashCodeBuilder().append(this.getFrom()).append(this.getTo()).toHashCode();
    }

    /**
     * @return
     */
    public String toString() {
        return new ToStringBuilder(this).append(this.getFrom()).append(this.getTo()).toString();
    }
}