/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.brownie.core.collection.CollectionSqueezer;

/**
 * @author akima
 */
public class EraGroup {

	/**
	 *  
	 */
	public EraGroup() {
		super();
	}

	private final Set eras = new HashSet();

	/**
	 * @param era
	 * @return
	 */
	public boolean add(Era era) {
		return eras.add(era);
	}

	/**
	 *  
	 */
	public void clear() {
		eras.clear();
	}

	/**
	 * @param era
	 * @return
	 */
	public boolean contains(Era era) {
		return eras.contains(era);
	}

	/**
	 * @param c
	 * @return
	 */
	public boolean containsAll(Collection c) {
		return eras.containsAll(c);
	}

	/**
	 * @return
	 */
	public boolean isEmpty() {
		return eras.isEmpty();
	}

	/**
	 * @return
	 */
	public Iterator iterator() {
		return eras.iterator();
	}

	/**
	 * @param era
	 * @return
	 */
	public boolean remove(Era era) {
		return eras.remove(era);
	}

	/**
	 * @return
	 */
	public int size() {
		return eras.size();
	}

	/**
	 * @return @see java.lang.Object#toString()
	 */
	public String toString() {
		return eras.toString();
	}

	/**
	 * tǂ̔Nɓ̂Ԃ\bhB
	 * 
	 * @param d
	 *            DOCUMENT ME!
	 * @return DOCUMENT ME!
	 */
	public Era getEra(SimpleDate d) {
		return getEra(Locale.getDefault(), d);
	}

	/**
	 * \񂩂Era擾B
	 */
	public Era findByCaptions(String str) {
		if (StringUtils.isEmpty(str))
			return null;
		final Iterator iterator = eras.iterator();
		while (iterator.hasNext()) {
			final Era era = (Era) iterator.next();
			if (era.equals(str))
				return era;
		}
		return null;
	}

	/**
	 * tǂ̔Nɓ̂Ԃ\bhB
	 * 
	 * @param locale
	 * @param d
	 * @return
	 */
	public Era getEra(Locale locale, SimpleDate d) {
		if (d == null)
			return null;
		final Iterator iterator = eras.iterator();
		final LocaleDateFilter filter = new LocaleDateFilter(locale, d);
		while (iterator.hasNext()) {
			final Era era = (Era) iterator.next();
			if (filter.evaluate(era))
				return era;
		}
		return null;
	}

	/**
	 * w肳ꂽP[ɊYN擾ASetŕԂB
	 * 
	 * @param locale
	 * @return
	 */
	public Set getEras(Locale locale) {
		final Set result = new HashSet();
		final CollectionSqueezer squeezer = new CollectionSqueezer(
				new LocaleFilter(locale));
		squeezer.execute(eras.iterator(), result);
		return result;
	}

	/**
	 * Date^̈YNŉNɓ̂Ԃ\bhB
	 * 
	 * @param d
	 *            DOCUMENT ME!
	 * @return DOCUMENT ME!
	 */
	public int getEraYear(SimpleDate d) {
		final Era era = getEra(d);
		return (era == null) ? d.getYear() : era.getYearAt(d);
	}

	/**
	 * w肳ꂽP[Date^̈YNŉNɓ̂Ԃ\bhB
	 * 
	 * @param d
	 *            DOCUMENT ME!
	 * @return DOCUMENT ME!
	 */
	public int getEraYear(Locale locale, SimpleDate d) {
		final Era era = getEra(locale, d);
		return (era == null) ? d.getYear() : era.getYearAt(d);
	}

}

class LocaleFilter implements Predicate {

	public LocaleFilter(Locale locale) {
		super();
		this.locale = locale;
	}

	final Locale locale;

	/**
	 * @param object
	 * @return @see org.asyrinx.util.Filter#match(java.lang.Object)
	 */
	public boolean evaluate(Object object) {
		if (!(object instanceof Era))
			return false;
		final Era era = (Era) object;
		return (locale == null) ? true : locale.equals(era.getLocale());
	}
}

class LocaleDateFilter extends LocaleFilter {

	public LocaleDateFilter(Locale locale, SimpleDate date) {
		super(locale);
		this.date = date;
	}

	final SimpleDate date;

	/**
	 * @param object
	 * @return @see org.asyrinx.util.Filter#match(java.lang.Object)
	 */
	public boolean evaluate(Object object) {
		if (!super.evaluate(object))
			return false;
		final Era era = (Era) object;
		return era.getRange().include(date);
	}

}