/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/14 17:28:37
 */
package org.asyrinx.brownie.core.xml.digester;

import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.digester.Rule;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.xml.sax.Attributes;

/**
 * @author akima
 */
public class ConstructorRule extends Rule {

    /**
     *  
     */
    public ConstructorRule(Class clazz, Class[] paramTypes, String[] paramNames) {
        super();
        this.clazz = clazz;
        this.paramTypes = paramTypes;
        this.paramNames = paramNames;
    }

    private final Class clazz;

    private final Class[] paramTypes;

    private final String[] paramNames;

    /**
     * @see org.apache.commons.digester.Rule#begin(org.xml.sax.Attributes)
     * @deprecated
     */
    public void begin(Attributes attributes) throws Exception {
        execute(attributes);
    }

    /**
     * @see org.apache.commons.digester.Rule#begin(java.lang.String,
     *        java.lang.String, org.xml.sax.Attributes)
     */
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        execute(attributes);
    }

    /**
     * @throws InstantiationException
     */
    private void execute(Attributes attributes) throws InstantiationException {
        Object[] params = new Object[this.paramNames.length];
        for (int i = 0; i < this.paramNames.length; i++) {
            final String paramName = this.paramNames[i];
            params[i] = ConvertUtils.convert(attributes.getValue(paramName), paramTypes[i]);
        }
        final Object bean = ClassUtils.newObject(clazz, null, params);
        digester.push(bean);
    }
}