/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.logger;

import java.util.Collection;

import javax.xml.transform.TransformerException;

import net.sf.hibernate.Databinder;
import net.sf.hibernate.HibernateException;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.hibernate.wrapper.DatabinderWrapper;
import org.w3c.dom.Document;

/**
 * @author akima
 */
public class LogDatabinder extends DatabinderWrapper {

    /**
     * @param wrapped
     * @param log
     */
    public LogDatabinder(Databinder wrapped, CascadeNamedLog parentLog) {
        super(wrapped);
        this.log = parentLog.subLog(wrapped);
    }

    protected final CascadeNamedLog log;

    /**
     * @see net.sf.hibernate.Databinder#bind(java.lang.Object)
     */
    public Databinder bind(Object object) {
        final Databinder result = super.bind(object);
        log.log("bind(" + object + ")");
        return new LogDatabinder(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Databinder#bindAll(java.util.Collection)
     */
    public Databinder bindAll(Collection objects) {
        final Databinder result = super.bindAll(objects);
        log.log("bindAll(" + objects + ")");
        return new LogDatabinder(result, log.subLog(result));
    }

    /**
     * @see net.sf.hibernate.Databinder#setInitializeLazy(boolean)
     */
    public void setInitializeLazy(boolean initializeLazy) {
        super.setInitializeLazy(initializeLazy);
    }

    /**
     * @see net.sf.hibernate.Databinder#toDOM()
     */
    public Document toDOM() throws HibernateException, TransformerException {
        return super.toDOM();
    }

    /**
     * @see net.sf.hibernate.Databinder#toGenericDOM()
     */
    public Document toGenericDOM() throws HibernateException {
        return super.toGenericDOM();
    }

    /**
     * @see net.sf.hibernate.Databinder#toGenericXML()
     */
    public String toGenericXML() throws HibernateException {
        return super.toGenericXML();
    }

    /**
     * @see net.sf.hibernate.Databinder#toXML()
     */
    public String toXML() throws HibernateException, TransformerException {
        return super.toXML();
    }

}