/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/27 19:35:13
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.SQLException;

import javax.sql.XAConnection;
import javax.sql.XADataSource;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.core.log.DispatchLog;
import org.asyrinx.brownie.jdbc.wrapper.XADataSourceWrapper;

/**
 * @author takeshi
 */
public class LogXADataSource extends XADataSourceWrapper {

    /**
     * @param wrapped
     */
    public LogXADataSource(XADataSource wrapped) {
        this(wrapped, new CascadeNamedLog(wrapped.getClass(), DispatchLog.DEFAULT_LEVEL));
    }

    /**
     * @param wrapped
     * @param name
     */
    public LogXADataSource(XADataSource wrapped, String name) {
        this(wrapped, new CascadeNamedLog(name, DispatchLog.DEFAULT_LEVEL));
    }

    /**
     * @param wrapped
     * @param log
     */
    public LogXADataSource(XADataSource wrapped, CascadeNamedLog log) {
        super(wrapped);
        this.log = log;
    }

    protected final CascadeNamedLog log;

    protected XAConnection toLogXAConnection(XAConnection connection) {
        return new LogXAConnection(connection, this.log.subLog(connection.getClass()));
    }

    public XAConnection getXAConnection() throws SQLException {
        try {
            final XAConnection result = super.getXAConnection();
            log.log("getXAConnection(): " + result);
            return toLogXAConnection(result);
        } catch (SQLException e) {
            log.error("failed to getXAConnection(): ", e);
            throw e;
        }
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        try {
            final XAConnection result = super.getXAConnection(user, password);
            log.log("getXAConnection(" + user + "," + password + "): " + result);
            return toLogXAConnection(result);
        } catch (SQLException e) {
            log.error("failed to getXAConnection(" + user + "," + password + "): ", e);
            throw e;
        }
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        try {
            super.setLoginTimeout(seconds);
            log.log("setLoginTimeout(" + seconds + ")");
        } catch (SQLException e) {
            log.error("failed to setLoginTimeout(" + seconds + ")", e);
            throw e;
        }
    }

}