/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/27 20:28:50
 */
package org.asyrinx.brownie.jdbc.logger;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.core.log.DispatchLog;
import org.asyrinx.brownie.jdbc.wrapper.XAResourceWrapper;

/**
 * @author takeshi
 */
public class LogXAResource extends XAResourceWrapper {

    /**
     * @param wrapped
     */
    public LogXAResource(XAResource wrapped) {
        this(wrapped, new CascadeNamedLog(wrapped.getClass(), DispatchLog.DEFAULT_LEVEL));
    }

    /**
     * @param wrapped
     */
    public LogXAResource(XAResource wrapped, CascadeNamedLog log) {
        super(wrapped);
        this.log = log;
    }

    protected final CascadeNamedLog log;

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            super.commit(xid, onePhase);
            log.log("commit(" + xid + "," + onePhase + ")");
        } catch (XAException e) {
            log.error("failed to commit(" + xid + "," + onePhase + ")", e);
            throw e;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            super.end(xid, flags);
            log.log("end(" + xid + "," + flags + ")");
        } catch (XAException e) {
            log.error("failed to end(" + xid + "," + flags + ")", e);
            throw e;
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            super.forget(xid);
            log.log("forget(" + xid + ")");
        } catch (XAException e) {
            log.error("failed to forget(" + xid + ")", e);
            throw e;
        }
    }

    public int getTransactionTimeout() throws XAException {
        try {
            final int result = super.getTransactionTimeout();
            log.log("getTransactionTimeout(): " + result);
            return result;
        } catch (XAException e) {
            log.error("failed to getTransactionTimeout(): ");
            throw e;
        }
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        try {
            final boolean result = super.isSameRM(xares);
            log.log("isSameRM(" + xares + "): " + result);
            return result;
        } catch (XAException e) {
            log.error("failed to isSameRM(" + xares + "): ");
            throw e;
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            final int result = super.prepare(xid);
            log.log("prepare(" + xid + "): " + result);
            return result;
        } catch (XAException e) {
            log.error("failed to prepare(" + xid + "): ");
            throw e;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            final Xid[] result = super.recover(flag);
            log.log("recover(" + flag + "): " + result);
            return result;
        } catch (XAException e) {
            log.error("failed to recover(" + flag + "): ");
            throw e;
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            super.rollback(xid);
            log.log("rollback(" + xid + ")");
        } catch (XAException e) {
            log.error("failed to rollback(" + xid + ")", e);
            throw e;
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            final boolean result = super.setTransactionTimeout(seconds);
            log.log("setTransactionTimeout(" + seconds + "): " + result);
            return result;
        } catch (XAException e) {
            log.error("failed to setTransactionTimeout(" + seconds + "): ");
            throw e;
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            super.start(xid, flags);
            log.log("start(" + xid + "," + flags + ")");
        } catch (XAException e) {
            log.error("failed to start(" + xid + "," + flags + ")", e);
            throw e;
        }
    }
}