/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/22
 */
package org.asyrinx.brownie.jdbc.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author akima
 */
public class JdbcDriverType {

	/**
	 *  
	 */
	protected JdbcDriverType(String productName, String innerName) {
		super();
		this.productName = productName;
		this.innerName = innerName;
		productMap.put(productName, this);
	}

	private static final Map productMap = new HashMap();

	private final String productName;

	private final String innerName;

	/**
	 * @return
	 */
	public String getInnerName() {
		return innerName;
	}

	/**
	 * @return
	 */
	public String getProductName() {
		return productName;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return productName;
	}

	public static JdbcDriverType get(String databaseProductName)
			throws SQLException {
		final JdbcDriverType result = (JdbcDriverType) productMap
				.get(databaseProductName);
		if (result == null)
			throw new SQLException("unknown kind of connection. ["
					+ databaseProductName
					+ "]. Now you can use these database."
					+ productMap.keySet());
		return result;
	}

	public static JdbcDriverType get(DatabaseMetaData metaData)
			throws SQLException {
		return get(metaData.getDatabaseProductName());
	}

	public static JdbcDriverType get(Connection connection) throws SQLException {
		return get(connection.getMetaData());
	}

	public static final JdbcDriverType POSTGRESQL = new JdbcDriverType(
			"PostgreSQL", "postgresql");

	public static final JdbcDriverType HSQL = new JdbcDriverType(
			"HSQL Database Engine", "hsql");

	public static final JdbcDriverType MYSQL = new JdbcDriverType("MySQL",
			"mysql");

}