/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/27 19:32:39
 */
package org.asyrinx.brownie.jdbc.wrapper;

import java.io.PrintWriter;
import java.sql.SQLException;

import javax.sql.XAConnection;
import javax.sql.XADataSource;

/**
 * @author takeshi
 */
public class XADataSourceWrapper implements XADataSource {

    /**
     *  
     */
    public XADataSourceWrapper(XADataSource wrapped) {
        super();
        this.wrapped = wrapped;
    }

    protected final XADataSource wrapped;

    public int getLoginTimeout() throws SQLException {
        return wrapped.getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return wrapped.getLogWriter();
    }

    public XAConnection getXAConnection() throws SQLException {
        return wrapped.getXAConnection();
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return wrapped.getXAConnection(user, password);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        wrapped.setLoginTimeout(seconds);
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        wrapped.setLogWriter(out);
    }
}