/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/27 19:52:01
 */
package org.asyrinx.brownie.jdbc.wrapper;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

/**
 * @author takeshi
 */
public class XAResourceWrapper implements XAResource {

    /**
     *  
     */
    public XAResourceWrapper(XAResource wrapped) {
        super();
        this.wrapped = wrapped;
    }

    protected final XAResource wrapped;

    public void commit(Xid xid, boolean onePhase) throws XAException {
        wrapped.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        wrapped.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        wrapped.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return wrapped.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return wrapped.isSameRM(xares);
    }

    public int prepare(Xid xid) throws XAException {
        return wrapped.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return wrapped.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        wrapped.rollback(xid);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return wrapped.setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        wrapped.start(xid, flags);
    }
}