/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/27
 */
package org.asyrinx.brownie.log.log4j.servlet;

import java.util.Properties;

import javax.servlet.ServletContext;

import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.FileWatchdog;
import org.asyrinx.brownie.log.log4j.PropertyConfigurator;
import org.asyrinx.brownie.servlet.FileNameResolver;

/**
 * @author akima
 */
public class ServletPropertyConfigurator extends PropertyConfigurator {

	/**
	 *  
	 */
	public ServletPropertyConfigurator(ServletContext servletContext) {
		super();
		this.resolver = new FileNameResolver(servletContext);
	}

	protected final FileNameResolver resolver;

	/**
	 * @see org.asyrinx.log.log4j.PropertyConfigurator#parseAppender(java.util.Properties,
	 *      java.lang.String)
	 */
	protected Appender parseAppender(Properties props, String appenderName) {
		final String fileKey = PropertyConfigurator.APPENDER_PREFIX
				+ appenderName + ".file";
		final String origPath = props.getProperty(fileKey);
		props.setProperty(fileKey, resolver.toRealPath(origPath));
		return super.parseAppender(props, appenderName);
	}

	/**
	 */
	static public void configure(String configFilename,
			ServletContext servletContext) {
		servletContext.log(ServletPropertyConfigurator.class.getName()
				+ "#ServletPropertyConfigurator.configure(\"" + configFilename
				+ "\")");
		new ServletPropertyConfigurator(servletContext).doConfigure(
				configFilename, LogManager.getLoggerRepository());
	}

	/**
	 * Like {@link #configureAndWatch(String, long)}except that the default
	 * delay as defined by {@link FileWatchdog#DEFAULT_DELAY}is used.
	 * 
	 * @param configFilename
	 *            A file in key=value format.
	 *  
	 */
	static public void configureAndWatch(String configFilename,
			ServletContext servletContext) {
		configureAndWatch(configFilename, FileWatchdog.DEFAULT_DELAY,
				servletContext);
	}

	/**
	 * Read the configuration file <code>configFilename</code> if it exists.
	 * Moreover, a thread will be created that will periodically check if
	 * <code>configFilename</code> has been created or modified. The period is
	 * determined by the <code>delay</code> argument. If a change or file
	 * creation is detected, then <code>configFilename</code> is read to
	 * configure log4j.
	 * 
	 * @param configFilename
	 *            A file in key=value format.
	 * @param delay
	 *            The delay in milliseconds to wait between each check.
	 */
	static public void configureAndWatch(String configFilename, long delay,
			ServletContext servletContext) {
		servletContext.log(ServletPropertyConfigurator.class.getName()
				+ "#ServletPropertyConfigurator.configureAndWatch(\""
				+ configFilename + "\")");
		ServletPropertyWatchdog pdog = new ServletPropertyWatchdog(
				configFilename, servletContext);
		pdog.setDelay(delay);
		pdog.start();
	}
}

class ServletPropertyWatchdog extends FileWatchdog {

	ServletPropertyWatchdog(String filename, ServletContext servletContext) {
		super(filename);
		this.servletContext = servletContext;
	}

	final ServletContext servletContext;

	/**
	 * Call {@link PropertyConfigurator#configure(String)}with the
	 * <code>filename</code> to reconfigure log4j.
	 */
	public void doOnChange() {
		new ServletPropertyConfigurator(servletContext).doConfigure(filename,
				LogManager.getLoggerRepository());
	}
}