/*
 * Created on 2004/11/16
 */
package org.asyrinx.brownie.pdf.fop.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.asyrinx.brownie.core.io.StreamUtils;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.core.xml.dom.XmlBeanWriter;
import org.asyrinx.brownie.pdf.fop.FopInvoker;
import org.asyrinx.brownie.pdf.fop.PdfException;
import org.asyrinx.brownie.pdf.fop.PdfMaker;

/**
 * @author takeshi
 */
public class PdfMakerImpl implements PdfMaker {

    /**
     * @param fopInvoker
     * @param xmlBeanWriter
     */
    public PdfMakerImpl(FopInvoker fopInvoker, XmlBeanWriter xmlBeanWriter) {
        super();
        this.fopInvoker = fopInvoker;
        this.xmlBeanWriter = xmlBeanWriter;
    }

    protected final FopInvoker fopInvoker;

    protected final XmlBeanWriter xmlBeanWriter;

    private OutputStream domOutput = null;

    protected final Log log = LogFactory.getLog(this.getClass());

    public void execute(Object bean, String xslFqn, OutputStream dest, String rootName) throws PdfException {
        final InputStream xsl;
        try {
            log.debug("loading xsl: " + xslFqn);
            xsl = StreamFactoryFacade.newFacade().newInput(xslFqn);
        } catch (IOException e) {
            log.error("failed to load xsl: " + xslFqn);
            throw new PdfException(e);
        }
        this.execute(bean, xsl, dest, rootName);
    }

    public void execute(Object bean, InputStream xsl, OutputStream dest, String rootName) throws PdfException {
        final ByteArrayOutputStream domOut = new ByteArrayOutputStream();
        //
        try {
            log.debug("building bean dom: " + bean);
            this.xmlBeanWriter.execute(bean, domOut, rootName);
        } catch (Exception e) {
            throw new PdfException("failed to build bean dom.", e);
        }
        final ByteArrayInputStream domIn = new ByteArrayInputStream(domOut.toByteArray());
        if (this.domOutput != null) {
            try {
                StreamUtils.copy(domIn, domOutput);
            } catch (IOException e1) {
                throw new PdfException("failed to output entity xml.");
            }
            domIn.reset();
        }
        this.execute(domIn, xsl, dest, rootName);
    }

    public void execute(InputStream beanDom, InputStream xsl, OutputStream dest, String rootName) throws PdfException {
        try {
            log.debug("invoking fop: ");
            this.fopInvoker.execute(beanDom, xsl, dest);
        } catch (FOPException e) {
            throw new PdfException(e);
        }
    }

    /**
     * @return Returns the domOutput.
     */
    public OutputStream getDomOutput() {
        return domOutput;
    }

    /**
     * @param domOutput
     *            The domOutput to set.
     */
    public void setDomOutput(OutputStream domOutput) {
        this.domOutput = domOutput;
    }
}